/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.folhapagamento.client.domain.CargoReduzidoDTO;
import br.com.elotech.folhapagamento.client.domain.MatrizSalarialDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoViewDTO;
import br.com.elotech.folhapagamento.client.domain.enums.CargoTipo;
import br.com.elotech.portaltransparencia.aiseportal.domain.Cargo;
import br.com.elotech.portaltransparencia.aiseportal.domain.GrupoOcupacional;
import br.com.elotech.portaltransparencia.aiseportal.domain.GrupoOcupacionalNivel;
import br.com.elotech.portaltransparencia.aiseportal.domain.QuadroSalarial;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.CargoFaixaDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.CargoService;
import br.com.elotech.portaltransparencia.aiseportal.service.IntegracaoAiseOxyFolhaPagamentoService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/cargos"})
public class CargoResource {
    private final CargoService cargoService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final IntegracaoAiseOxyFolhaPagamentoService integracaoAiseOxyService;

    public CargoResource(CargoService cargoService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository, IntegracaoAiseOxyFolhaPagamentoService integracaoAiseOxyService) {
        this.cargoService = cargoService;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.integracaoAiseOxyService = integracaoAiseOxyService;
    }

    @GetMapping
    public ResponseEntity<Page<CargoFaixaDTO>> findCargos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid CargoParams params, @RequestParam(value="descricao", required=false) String descricao, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        params.setDescricao(descricao);
        return ResponseEntity.ok((Object)this.cargoService.findCargos(params, pageable));
    }

    @GetMapping(value={"/faixas"})
    public ResponseEntity<List<CargoFaixaDTO>> findFaixas(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid CargoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.cargoService.findFaixas(params));
    }

    @GetMapping(value={"/cargos"})
    public ResponseEntity<List<Cargo>> findCargo(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid CargoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.cargoService.findCargo(params));
    }

    @GetMapping(value={"/quadros"})
    public ResponseEntity<List<QuadroSalarial>> findQuadroSalarial(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @RequestParam(value="descricao", required=false) String descricao, @Valid CargoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        params.setDescricao(descricao);
        return ResponseEntity.ok((Object)this.cargoService.findQuadroSalarial(params));
    }

    @GetMapping(value={"/grupos"})
    public ResponseEntity<List<GrupoOcupacional>> findGrupoOcupacional(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @RequestParam(value="descricao", required=false) String descricao, @Valid CargoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        params.setDescricao(descricao);
        return ResponseEntity.ok((Object)this.cargoService.findGrupoOcupacional(params));
    }

    @GetMapping(value={"/niveis"})
    public ResponseEntity<List<GrupoOcupacionalNivel>> findGrupoOcupacionalNivel(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @RequestParam(value="descricao", required=false) String descricao, @Valid CargoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        params.setDescricao(descricao);
        return ResponseEntity.ok((Object)this.cargoService.findGrupoOcupacionalNivel(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView exportCargos(HttpServletRequest request, HttpServletResponse response, Pageable pageable, @RequestParam(value="entidade", required=true) Long entidade, @RequestParam(value="exercicio", required=true) Long exercicio, @Valid CargoParams params, @RequestParam(value="exportType", required=true) String exportType) throws Throwable {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        if (this.integracaoAiseOxyService.isParametroHabilitado(entidade, exercicio)) {
            return this.exportar(request, response, exportType, params);
        }
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros());
        Page page = this.cargoService.findCargos(params, (Pageable)pageRequest);
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade("");
        reportParam.setReportTitle("Listagem de Cargos");
        reportParam.setClazzDTO(CargoFaixaDTO.class);
        reportParam.setHeaderFields("Cargo,Quadro Salarial,Grupo Ocupacional,N\u00edvel,Vagas Total,Vagas Ocupadas");
        reportParam.setFields("descricao,quadroSalarialDesc,grupoOcupacionalDesc,nivelDesc,vagasTotal,vagasOcupadas");
        float[] fieldsPerc = new float[]{2.0f, 2.0f, 2.0f, 2.0f, 1.0f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{50, 50, 50, 50, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(exportType);
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/cargo-faixa/report"})
    public ModelAndView exportCargosFaixa(HttpServletRequest request, HttpServletResponse response, Pageable pageable, @RequestParam(value="entidade", required=true) Long entidade, @RequestParam(value="exercicio", required=true) Long exercicio, @Valid CargoParams params, @RequestParam(value="exportType", required=true) String exportType) throws Throwable {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        if (this.integracaoAiseOxyService.isParametroHabilitado(entidade, exercicio)) {
            return null;
        }
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros());
        List list = this.cargoService.findFaixas(params);
        PageImpl page = new PageImpl(list, pageable, (long)list.size());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade("");
        reportParam.setReportTitle("Listagem de Cargo Faixas");
        reportParam.setClazzDTO(CargoFaixaDTO.class);
        reportParam.setHeaderFields("Faixa,Descri\u00e7\u00e3o,Sal\u00e1rio,Valor gratifica\u00e7\u00e3o");
        reportParam.setFields("faixa,faixaDesc,valor,valorGratificacao");
        float[] fieldsPerc = new float[]{2.0f, 2.0f, 1.0f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{50, 50, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage((Page)page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(exportType);
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/busca-cargos"})
    public ResponseEntity<Page<PortalTransparenciaCargoDTO>> findCargosOxy(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid CargoParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.cargoService.findCargosOxy(params, pageable));
    }

    @GetMapping(value={"/matriz-vigente"})
    public ResponseEntity<List<PortalTransparenciaCargoViewDTO>> getMatrizVigente(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid CargoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.cargoService.getMatrizVigente(params));
    }

    @GetMapping(value={"/tipo-cargo"})
    public ResponseEntity<List<CargoTipo>> getTipoCargo(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @RequestParam(value="descricao", required=false) String descricao) {
        return ResponseEntity.ok((Object)this.cargoService.getTipoCargo(descricao));
    }

    @GetMapping(value={"/matrizes-vigencia"})
    public ResponseEntity<List<String>> getVigenciasMatrizSalarial(@RequestParam(value="matriz") Long matrizId) {
        return ResponseEntity.ok((Object)this.cargoService.getVigenciasMatrizSalarial(matrizId));
    }

    @GetMapping(value={"/dados-cargos"})
    public ResponseEntity<List<CargoReduzidoDTO>> getCargos(@RequestHeader(value="entidade") Long entidadeId, @RequestParam(value="descricao", required=false) String descricao) {
        return ResponseEntity.ok((Object)this.cargoService.getCargosReduzido(entidadeId, descricao));
    }

    @GetMapping(value={"/matrizes"})
    public ResponseEntity<List<MatrizSalarialDTO>> findAllMatrizSalarial(@RequestHeader(value="entidade") Long entidadeId, @RequestParam(value="nomeMatrizSalarial", required=false) String nomeMatrizSalarial) {
        return ResponseEntity.ok((Object)this.cargoService.findAllMatrizSalarial(entidadeId, nomeMatrizSalarial));
    }

    private ModelAndView exportar(HttpServletRequest request, HttpServletResponse response, String exportType, CargoParams params) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros());
        Page page = this.cargoService.findCargosOxy(params, (Pageable)pageRequest);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setClazzDTO(PortalTransparenciaCargoDTO.class);
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Listagem de Cargos");
        reportParam.setHeaderFields("Cargo,Quadro Salarial,Grupo Ocupacional,N\u00edvel,Vagas Total,Vagas Ocupadas");
        reportParam.setFields("descricao,quadroSalarialDesc,grupoOcupacionalDesc,nivelDesc,vagasTotal,vagasOcupadas");
        float[] fieldsPerc = new float[]{2.0f, 2.0f, 2.0f, 2.0f, 1.0f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{50, 50, 50, 50, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(exportType);
        return this.baseExport.toExport(reportParam);
    }
}

