/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AditivoConvenioDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ConvenioDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseConvenioDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindConvenioParams;
import br.com.elotech.portaltransparencia.contabportal.service.ConvenioService;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/convenios"})
public class ConvenioResource {
    private final ConvenioService convenioService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final EntidadeContabilidadeService entidadeService;

    public ConvenioResource(ConvenioService convenioService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository, EntidadeContabilidadeService entidadeService) {
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.convenioService = convenioService;
        this.entidadeService = entidadeService;
    }

    @GetMapping
    public ResponseEntity<Page<ConvenioDTO>> findConvenios(@RequestHeader(value="entidade") Long entidade, FindConvenioParams params, Pageable pageable) {
        params.setEntidade(entidade);
        return ResponseEntity.ok((Object)this.convenioService.findConvenios(params, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findConveniosExport(HttpServletRequest request, HttpServletResponse response, FindConvenioParams params, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.convenioService.findConvenios(params, (Pageable)pageRequest);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)this.entidadeService.getEntidadeSelecionada(params.getEntidade()).getId());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Conv\u00eanios");
        reportParam.setClazzDTO(ConvenioDTO.class);
        reportParam.setHeaderFields("Entidade,Conv\u00eanio,Destinat\u00e1rio/Repassador,Valor,CNPJ/CPF,Parcelas,Situa\u00e7\u00e3o,Justificativa,In\u00edcio,T\u00e9rmino,Fonte");
        reportParam.setFields("entidade,displayConvenio,nome,valorConvenio,cnpj,qtParcelas,situacao,dsObjeto,dataInicioVigencia,dataFimVigencia,descricaoFonte");
        float[] fieldsPerc = new float[]{0.5f, 0.5f, 2.0f, 0.7f, 0.7f, 0.5f, 1.0f, 1.9f, 0.7f, 0.7f, 1.3f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{15, 15, 100, 15, 15, 15, 15, 500, 20, 20, 100};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(params={"entidade", "id", "nrConvenio", "nrAnoConvenio"})
    public ResponseEntity<ConvenioDTO> findConvenio(FindConvenioParams params) {
        return this.convenioService.findConvenio(params).map(ResponseEntity::ok).orElseThrow(() -> RestException.notFound((String)"N\u00e3o foi poss\u00edvel encontrar o conv\u00eanio."));
    }

    @GetMapping(value={"/link"}, params={"entidade", "nrConvenio", "nrAnoConvenio"})
    public ResponseEntity<ConvenioDTO> findConvenioWhitoutId(FindConvenioParams params) {
        return this.convenioService.findConvenio(params).map(ResponseEntity::ok).orElseThrow(() -> RestException.notFound((String)"N\u00e3o foi poss\u00edvel encontrar o conv\u00eanio."));
    }

    @GetMapping(value={"/arquivos"}, params={"entidade", "id"})
    public ResponseEntity<List<ArquivoPessoalDTO>> findArquivos(FindConvenioParams params) {
        return ResponseEntity.ok((Object)this.convenioService.findArquivos(params));
    }

    @GetMapping(value={"/convenio-anexo/download/{id}"})
    public void downloadConvenioAnexo(@PathVariable(value="id") Long id, HttpServletResponse response) throws IOException {
        ArquivoDTO arquivoDTO = this.convenioService.findArquivoDownload(id);
        if (!Objects.nonNull(arquivoDTO) || !Objects.nonNull(arquivoDTO.getArquivoFisico())) {
            throw RestException.notFound((String)"Arquivo n\u00e3o encontrado!");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivoDTO.getArquivoFisico(), (String)arquivoDTO.getNomeArquivo());
    }

    @GetMapping(value={"/aditivos"}, params={"entidade", "id"})
    public ResponseEntity<List<AditivoConvenioDTO>> findAditivos(FindConvenioParams params) {
        return ResponseEntity.ok((Object)this.convenioService.findAditivos(params));
    }

    @GetMapping(value={"/repasses"}, params={"entidade", "id"})
    public ResponseEntity<List<RepasseConvenioDTO>> findRepassesConvenio(FindConvenioParams params) {
        return ResponseEntity.ok((Object)this.convenioService.findRepassesConvenio(params));
    }

    @GetMapping(value={"/contrapartida"}, params={"entidade", "id", "idContaCorrente"})
    public ResponseEntity<List<RepasseConvenioDTO>> findContraPartida(FindConvenioParams params) {
        return ResponseEntity.ok((Object)this.convenioService.findContraPartida(params));
    }

    @GetMapping(value={"/pagamentos"}, params={"entidade", "idContaCorrente", "local"})
    public ResponseEntity<List<RepasseConvenioDTO>> findPagamentosConvenio(FindConvenioParams params) {
        if (params.getIdContaCorrente().isEmpty()) {
            return ResponseEntity.ok(Collections.emptyList());
        }
        return ResponseEntity.ok((Object)this.convenioService.findPagamentosConvenio(params));
    }
}

