/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ContratoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.ContratoRepository;
import br.com.elotech.portaltransparencia.comprasportal.repository.impl.LicitacaoRepositoryImpl;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindContratoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.Empenho;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.Exercicio;
import br.com.elotech.portaltransparencia.contabportal.domain.ExercicioPK;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoAnexosDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoAnulacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDocumentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoEmLiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoItensDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoLinksDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoLiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoMovimentacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoPagamentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoRestosAPagarDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoRetencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhosListaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EmpenhoCustomRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.ExercicioRepository;
import br.com.elotech.portaltransparencia.utils.MaskFormatterUtils;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import br.com.elotech.portaltransparencia.web.rest.params.EmpenhoParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class EmpenhoRepositoryImpl
implements EmpenhoCustomRepository {
    private static final String EMPENHO = "db/sql/contab/empenho.sql";
    private static final String EMPENHOITENS = "db/sql/contab/empenhoItens.sql";
    private static final String EMPENHOANULACAO = "db/sql/contab/empenhoAnulacao.sql";
    private static final String EMPENHOLIQUIDACAO = "db/sql/contab/empenhoLiquidacao.sql";
    private static final String EMPENHOPAGAMENTO = "db/sql/contab/empenhoPagamento.sql";
    private static final String EMPENHORETENCAO = "db/sql/contab/empenhoRetencao.sql";
    private static final String EMPENHORETENCAOORDEMPAGAMENTO = "db/sql/contab/empenhoRetencaoOrdemPagamento.sql";
    private static final String EMPENHODOCUMENTO = "db/sql/contab/empenhoDocumentos.sql";
    private static final String EMPENHOMOVIMENTACAO = "db/sql/contab/empenhoMovimentacao.sql";
    private static final String EMPENHOANEXOS = "db/sql/contab/empenhoAnexos.sql";
    private static final String EMPENHOEMLIQUIDACAO = "db/sql/contab/empenhoEmLiquidacao.sql";
    private static final String EMPENHOLINKS = "db/sql/contab/empenhoLinks.sql";
    private static final String EMPENHORESTOSAPAGAR = "db/sql/contab/empenhoRestosAPagar.sql";
    private static final int TIPOEMPENHO = 20;
    private static final int TIPOANULACAO = 21;
    private static final int TIPOESTORNOANULACAO = 22;
    private static final int TIPOLIQUIDACAO = 30;
    private static final int TIPOESTORNOLIQUIDACAO = 31;
    private static final int TIPORETENCAO = 50;
    private static final int TIPOESTORNORETENCAO = 51;
    private static final int TIPOPAGAMENTO = 40;
    private static final int TIPOESTORNOPAGAMENTO = 41;
    private final DatasourceWrapper datasourceWrapper;
    private final EntityManager entityManagerManager;
    private final ExercicioRepository exercicioRepository;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final ContratoRepository contratoRepository;
    private LicitacaoRepositoryImpl licitacaoRepository;
    @Autowired
    private PortalParametroRepository portalparametrorepository;

    @Autowired
    public EmpenhoRepositoryImpl(EntidadeContabilidadeRepository entidadeRepository, ExercicioRepository exercicioRepository, ContratoRepository contratoRepository, DatasourceWrapper datasourceWrapper, EntityManager entityManagerManager) {
        this.entidadeRepository = entidadeRepository;
        this.exercicioRepository = exercicioRepository;
        this.entityManagerManager = entityManagerManager;
        this.contratoRepository = contratoRepository;
        this.datasourceWrapper = datasourceWrapper;
    }

    public EmpenhoDTO getEmpenhoDetalhe(EmpenhoParams params) {
        this.licitacaoRepository = new LicitacaoRepositoryImpl(this.datasourceWrapper, this.portalparametrorepository);
        String sql = FileUtils.readResourceAsString((String)EMPENHO) + params.montaFiltro();
        List list = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoDTO.class));
        if (list.isEmpty()) {
            return new EmpenhoDTO();
        }
        Entidade entidade = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        Exercicio exercicio = (Exercicio)this.exercicioRepository.findOne((Object)ExercicioPK.builder().entidade(entidade).exercicio(params.getExercicio()).build());
        EmpenhoDTO empenho = (EmpenhoDTO)list.get(0);
        if (exercicio.getModeloDespesa() != null && empenho.getProgramatica() != null) {
            empenho.setProgramatica(MaskFormatterUtils.getMaskFormatado((String)empenho.getProgramatica(), (String)exercicio.getModeloDespesa().getMascara()));
        }
        if (Objects.nonNull(empenho.getNoLicitacao()) && !empenho.getNoLicitacao().isEmpty() && Objects.nonNull(empenho.getAnoLicitacao()) && empenho.getAnoLicitacao() > 0L) {
            FindLicitacaoParams licitacaoParams = new FindLicitacaoParams();
            licitacaoParams.setExercicio(empenho.getAnoLicitacao());
            licitacaoParams.setEntidade(empenho.getEntidade());
            licitacaoParams.setEmpenho(empenho.getEmpenho());
            licitacaoParams.setAnoNadEmpenho(empenho.getAnoNad());
            licitacaoParams.setNoNadEmpenho(empenho.getNoNad());
            licitacaoParams.setNumeroLicitacao(Long.valueOf(empenho.getNoLicitacao()));
            licitacaoParams.setTipoLicitacao(Long.valueOf(empenho.getTipoLicitacaoCompras()));
            try {
                LicitacaoDTO licitacaoDTO = this.licitacaoRepository.findLicitacao(licitacaoParams);
                empenho.setLicitacao(licitacaoDTO.getLicitacao());
            }
            catch (EmptyResultDataAccessException e) {
                empenho.setLicitacao(Long.valueOf(0L));
            }
        }
        if (Objects.isNull(empenho.getContrato())) {
            return empenho;
        }
        FindContratoParams contratoParam = new FindContratoParams();
        contratoParam.setEntidade(empenho.getEntidade());
        contratoParam.setExercicio(empenho.getAnoContrato());
        contratoParam.setNumeroContrato(empenho.getContrato());
        contratoParam.setIdContrato(empenho.getNoContrato());
        if (Objects.nonNull(empenho.getTipoContrato()) && empenho.getTipoContrato() != 0L) {
            contratoParam.setTipoAto(empenho.getTipoContrato());
        }
        if (Objects.nonNull(empenho.getNoLicitacao()) && !empenho.getNoLicitacao().isEmpty()) {
            contratoParam.setNumeroLicitacao(Long.valueOf(Long.parseLong(empenho.getNoLicitacao())));
        }
        contratoParam.setExercicioLicitacao(empenho.getAnoLicitacao());
        ContratoDTO contrato = this.contratoRepository.findContrato(contratoParam);
        empenho.setContrato(contrato.getNumeroContrato());
        empenho.setIdContrato(contrato.getContrato());
        empenho.setObjeto(contrato.getObjeto());
        return empenho;
    }

    public EmpenhosListaDTO geTotaisEmpenhos(EmpenhoParams params, Specification<Empenho> spec) {
        CriteriaBuilder cb = this.entityManagerManager.getCriteriaBuilder();
        CriteriaQuery rootQuery = cb.createQuery(EmpenhosListaDTO.class);
        Root root = rootQuery.from(Empenho.class);
        ListJoin fichaempenhoRoot = root.joinList("fichasEmpenho");
        Expression valorEmpenhado = cb.sum((Expression)fichaempenhoRoot.get("valor"));
        Expression valorAnulado = cb.sum(cb.diff((Expression)fichaempenhoRoot.get("valorAnulacoes"), (Expression)fichaempenhoRoot.get("valorEstAnulacoes")));
        Expression valorLiquidado = cb.sum(cb.diff((Expression)fichaempenhoRoot.get("valorLiquidacoes"), (Expression)fichaempenhoRoot.get("valorEstLiquidacoes")));
        Expression valorPago = cb.sum(cb.diff((Expression)fichaempenhoRoot.get("valorPagamento"), (Expression)fichaempenhoRoot.get("valorEstPagamento")));
        Expression valorRetido = cb.sum((Expression)fichaempenhoRoot.get("valorRetencoes"));
        Expression valorAPagar = cb.diff(cb.diff(cb.diff(valorEmpenhado, valorAnulado), valorPago), valorRetido);
        rootQuery.multiselect(new Selection[]{valorEmpenhado, valorAnulado, valorLiquidado, valorRetido, valorPago, valorAPagar}).where((Expression)spec.toPredicate(root, rootQuery, cb));
        return (EmpenhosListaDTO)this.entityManagerManager.createQuery(rootQuery).getSingleResult();
    }

    public List<EmpenhoItensDTO> getEmpenhoDetalheItens(EmpenhoParams params) {
        String sql = FileUtils.readResourceAsString((String)EMPENHOITENS) + params.montaFiltro() + " ORDER BY A.ORDEM ";
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoItensDTO.class));
    }

    public List<EmpenhoAnulacaoDTO> getEmpenhoDetalheAnulacao(EmpenhoParams params) {
        String sql = FileUtils.readResourceAsString((String)EMPENHOANULACAO) + params.montaFiltro() + " AND A.DATAESTORNO IS NULL ORDER BY A.ANULACAO ";
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoAnulacaoDTO.class));
    }

    public List<EmpenhoLiquidacaoDTO> getEmpenhoDetalheLiquidacao(EmpenhoParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)EMPENHOLIQUIDACAO));
        sql.append(params.montaFiltro());
        if (Objects.nonNull(params.getNoLiquidacao())) {
            sql.append("\n AND L.NOLIQUIDACAO = :noLiquidacao");
        }
        sql.append(" AND L.CONTABILIZADO = 'S' ORDER BY L.NOLIQUIDACAO ");
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoLiquidacaoDTO.class));
    }

    public List<EmpenhoPagamentoDTO> getEmpenhoDetalhePagamento(EmpenhoParams params) {
        String sql = FileUtils.readResourceAsString((String)EMPENHOPAGAMENTO) + params.montaFiltro() + " AND PAG.ESTORNO = 'N' ORDER BY PAG.DATA, PAG.NOPAGAMENTO ";
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoPagamentoDTO.class));
    }

    public List<EmpenhoRetencaoDTO> getEmpenhoDetalheRetencao(EmpenhoParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)EMPENHORETENCAO));
        sql.append(params.montaFiltro());
        if (Objects.nonNull(params.getNoLiquidacao())) {
            sql.append("\n AND L.NOLIQUIDACAO = :noLiquidacao");
        }
        sql.append(" AND L.DATACONTABILIZADO IS NOT NULL ");
        sql.append(" GROUP BY L.ENTIDADE, L.ANODOCORIGEM, L.NODOCORIGEM, L.UNIDADEDOCORIGEM, ");
        sql.append(" L.EXERCICIO, L.NOLIQUIDACAO, L.DATACONTABILIZADO, ");
        sql.append(" CASE WHEN TX.CODIGO = 17 THEN '[F] - Pens\u00e3o Aliment\u00edcia' ELSE COALESCE(CC.DESCRICAO, COALESCE(R.DESCRICAO,P.DESCRICAO)) END");
        sql.append(" ORDER BY L.DATACONTABILIZADO, L.NOLIQUIDACAO ");
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoRetencaoDTO.class));
    }

    public List<EmpenhoRetencaoDTO> getEmpenhoDetalheRetencaoOrdemPagamento(EmpenhoParams params) {
        String sql = FileUtils.readResourceAsString((String)EMPENHORETENCAOORDEMPAGAMENTO) + params.montaFiltro() + " GROUP BY OPR.ENTIDADE, OPR.ANODOCORIGEM, OPR.NODOCORIGEM, OPR.UNIDADEDOCORIGEM,  OPR.EXERCICIO, OPR.NOLIQUIDACAO, OP.DATA,  CASE WHEN COALESCE(TX.CODIGO, 0) = 17 THEN '[F] - PENS\u00c3O ALIMENT\u00cdCIA' ELSE COALESCE(CC.DESCRICAO, P.DESCRICAO) END ORDER BY OP.DATA, OPR.NOLIQUIDACAO ";
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoRetencaoDTO.class));
    }

    public List<EmpenhoDocumentoDTO> getEmpenhoDetalheDocumentos(EmpenhoParams params) {
        String sql = FileUtils.readResourceAsString((String)EMPENHODOCUMENTO) + params.montaFiltro() + " ORDER BY A.DATA ";
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoDocumentoDTO.class));
    }

    public Page<EmpenhoMovimentacaoDTO> getEmpenhoDetalheMovimentacao(Pageable pageable, EmpenhoParams params) {
        String sql = FileUtils.readResourceAsString((String)EMPENHOMOVIMENTACAO);
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)sql, (String)this.datasourceWrapper.getPlatform());
        List list = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoMovimentacaoDTO.class));
        BigDecimal valorALiquidar = BigDecimal.ZERO;
        BigDecimal valorAPagar = BigDecimal.ZERO;
        for (EmpenhoMovimentacaoDTO emp : list) {
            switch (emp.getTipoLancamento().intValue()) {
                case 20: 
                case 22: 
                case 31: {
                    valorALiquidar = valorALiquidar.add(emp.getValor());
                    break;
                }
                case 21: 
                case 30: {
                    valorALiquidar = valorALiquidar.subtract(emp.getValor());
                    break;
                }
            }
            switch (emp.getTipoLancamento().intValue()) {
                case 20: 
                case 22: 
                case 41: 
                case 51: {
                    valorAPagar = valorAPagar.add(emp.getValor());
                    break;
                }
                case 21: 
                case 40: 
                case 50: {
                    valorAPagar = valorAPagar.subtract(emp.getValor());
                    break;
                }
            }
            emp.setValorALiquidar(valorALiquidar);
            emp.setValorAPagar(valorAPagar);
        }
        String sqlCount = FileUtils.readResourceAsString((String)EMPENHOMOVIMENTACAO);
        return new PageImpl(list, pageable, this.getCountQuery(sqlCount, params.toJdbcParameter()).longValue());
    }

    public List<EmpenhoMovimentacaoDTO> getEmpenhoDetalheMovimentacao(EmpenhoParams params) {
        String sql = FileUtils.readResourceAsString((String)EMPENHOMOVIMENTACAO);
        List list = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoMovimentacaoDTO.class));
        BigDecimal valorALiquidar = BigDecimal.ZERO;
        BigDecimal valorAPagar = BigDecimal.ZERO;
        for (EmpenhoMovimentacaoDTO emp : list) {
            switch (emp.getTipoLancamento().intValue()) {
                case 20: 
                case 22: 
                case 31: {
                    valorALiquidar = valorALiquidar.add(emp.getValor());
                    break;
                }
                case 21: 
                case 30: {
                    valorALiquidar = valorALiquidar.subtract(emp.getValor());
                    break;
                }
            }
            switch (emp.getTipoLancamento().intValue()) {
                case 20: 
                case 22: 
                case 41: 
                case 51: {
                    valorAPagar = valorAPagar.add(emp.getValor());
                    break;
                }
                case 21: 
                case 40: 
                case 50: {
                    valorAPagar = valorAPagar.subtract(emp.getValor());
                    break;
                }
            }
            emp.setValorALiquidar(valorALiquidar);
            emp.setValorAPagar(valorAPagar);
        }
        return list;
    }

    private String getMostrarAnexo(EmpenhoParams params) {
        PortalParametroContabil paramContabil = this.portalparametrorepository.findOneByIdEntidadeAndIdExercicioAndIdId(params.getEntidade(), params.getExercicio(), Parametros.PARAM_MOSTRA_ANEXOS_CENTRAL_PAG);
        if (paramContabil == null) {
            return "N";
        }
        return paramContabil.getValor();
    }

    public List<EmpenhoAnexosDTO> getEmpenhoDetalheAnexos(EmpenhoParams params, String nomeSchemaEloArquivo) {
        String mostrarAnexo = this.getMostrarAnexo(params);
        String sql = FileUtils.readResourceAsString((String)EMPENHOANEXOS).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        String query = sql + params.montaFiltro() + "\n AND CASE WHEN '" + mostrarAnexo + "' = 'S' THEN 1  WHEN '" + mostrarAnexo + "' = 'N' AND UPPER(E.TIPOANEXO) = 'PAGAMENTOS' THEN 0  ELSE 1 END = 1";
        return this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoAnexosDTO.class));
    }

    public List<EmpenhoLinksDTO> getEmpenhoDetalheLinks(EmpenhoParams params) {
        String sql = FileUtils.readResourceAsString((String)EMPENHOLINKS);
        String query = sql + params.montaFiltro();
        return this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoLinksDTO.class));
    }

    public List<EmpenhoEmLiquidacaoDTO> getEmpenhoDetalheEmLiquidacao(EmpenhoParams params) {
        String sql = FileUtils.readResourceAsString((String)EMPENHOEMLIQUIDACAO);
        sql = sql.replace("$[FILTRO]", " AND EL.NODOCORIGEM = :empenho ");
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoEmLiquidacaoDTO.class));
    }

    public EmpenhoDTO getDadosPreview(EmpenhoParams params) {
        String sql = FileUtils.readResourceAsString((String)EMPENHO) + params.montaFiltro();
        List list = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoDTO.class));
        if (list.isEmpty()) {
            return new EmpenhoDTO();
        }
        EmpenhoDTO empenho = (EmpenhoDTO)list.get(0);
        empenho.setItens(this.getEmpenhoDetalheItens(params));
        return empenho;
    }

    private Long getCountQuery(String query, MapSqlParameterSource parameter) {
        String queryCount = "SELECT COUNT(*) FROM (" + query + ") COUNT";
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount, (SqlParameterSource)parameter, Long.class);
    }

    public String getFiltroComplementarRestosAPagar(EmpenhoParams params) {
        StringBuilder where = new StringBuilder();
        where.append(" WHERE 1=1 ");
        if (Objects.nonNull(params.getTipoPesquisa()) && !params.getTipoPesquisa().equals("")) {
            if (params.getTipoPesquisa().equalsIgnoreCase("Processados")) {
                where.append(" AND X.PROC > 0.001 ");
            } else {
                where.append(" AND X.APROC > 0.001 ");
            }
        }
        if (Objects.nonNull(params.getProgramatica())) {
            if (Objects.nonNull(params.getProgramatica().getOrgao())) {
                where.append("\n AND SUBSTR(X.PROGRAMATICA,ORG.POSICAO,ORG.TAMANHO) = '").append(params.getProgramatica().getOrgao()).append("'");
            }
            if (Objects.nonNull(params.getProgramatica().getUnidade())) {
                where.append("\n AND SUBSTR(X.PROGRAMATICA,UNID.POSICAO,UNID.TAMANHO) = '").append(params.getProgramatica().getUnidade()).append("'");
            }
            if (Objects.nonNull(params.getProgramatica().getFuncao())) {
                where.append("\n AND SUBSTR(X.PROGRAMATICA,FUNCAO.POSICAO,FUNCAO.TAMANHO) = '").append(params.getProgramatica().getFuncao()).append("'");
            }
            if (Objects.nonNull(params.getProgramatica().getSubFuncao())) {
                where.append("\n AND SUBSTR(X.PROGRAMATICA,SUBFUNCAO.POSICAO,SUBFUNCAO.TAMANHO) = '").append(params.getProgramatica().getSubFuncao()).append("'");
            }
            if (Objects.nonNull(params.getProgramatica().getPrograma())) {
                where.append("\n AND SUBSTR(X.PROGRAMATICA,PROG.POSICAO,PROG.TAMANHO) = '").append(params.getProgramatica().getPrograma()).append("'");
            }
            if (Objects.nonNull(params.getProgramatica().getProjeto())) {
                where.append("\n AND SUBSTR(X.PROGRAMATICA,PROJ.POSICAO,PROJ.TAMANHO) = '").append(params.getProgramatica().getProjeto()).append("'");
            }
            if (Objects.nonNull(params.getProgramatica().getElemento())) {
                where.append("\n AND SUBSTR(X.PROGRAMATICA,ELEM.POSICAO,ELEM.TAMANHO) = '").append(params.getProgramatica().getElemento()).append("'");
            }
        }
        return where.toString();
    }

    public Page<EmpenhoRestosAPagarDTO> getEmpenhoRestosAPagar(EmpenhoParams params, Pageable pageable) {
        String filter = params.montaFiltroRestos();
        Object sql = FileUtils.readResourceAsString((String)EMPENHORESTOSAPAGAR);
        sql = ((String)sql).replace("$[FILTRO]", filter) + this.getFiltroComplementarRestosAPagar(params);
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)" ORDER BY X.ANOEMPENHO, X.EMPENHO ");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        List restosAPagar = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoRestosAPagarDTO.class));
        return new PageImpl(restosAPagar, pageable, this.getCountQuery((String)sql, params.toJdbcParameter()).longValue());
    }
}

