/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.admportal.domain.EmendaParlamentar;
import br.com.elotech.portaltransparencia.admportal.domain.dto.EmendaParlamentarDTO;
import br.com.elotech.portaltransparencia.admportal.domain.dto.converter.EmendaParlamentarConverter;
import br.com.elotech.portaltransparencia.admportal.resource.params.EmendaParlamentarParams;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.EntidadeComprasDTO;
import br.com.elotech.portaltransparencia.comprasportal.service.impl.EntidadeComprasService;
import br.com.elotech.portaltransparencia.contabportal.service.EmendaParlamentarService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/emendas-parlamentares", "/admin/emendas-parlamentares"})
public class EmendaParlamentarResource {
    private final EmendaParlamentarService emendaParlamentarService;
    private final ElotechProperties elotechProperties;
    private final EntidadeComprasService entidadeComprasService;
    private final BaseExport baseExport;

    @Autowired
    public EmendaParlamentarResource(EmendaParlamentarService emendaParlamentarService, ElotechProperties elotechProperties, EntidadeComprasService entidadeComprasService, BaseExport baseExport) {
        this.emendaParlamentarService = emendaParlamentarService;
        this.elotechProperties = elotechProperties;
        this.entidadeComprasService = entidadeComprasService;
        this.baseExport = baseExport;
    }

    @GetMapping(value={"/list"})
    public ResponseEntity<List<EmendaParlamentar>> findEmendaParlamentar(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        return ResponseEntity.ok((Object)this.emendaParlamentarService.findEmendaParlamentar(entidade, exercicio));
    }

    @GetMapping
    public ResponseEntity<Page<EmendaParlamentar>> findEmendas(@RequestParam(value="entidade", required=false) Long entidade, @RequestParam(value="exercicio", required=false) Long exercicio, @Valid EmendaParlamentarParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.emendaParlamentarService.findByParams(params, pageable));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<EmendaParlamentarDTO> findOne(@PathVariable(value="id") Long id) {
        EmendaParlamentar emendaParlamentar = this.emendaParlamentarService.findOne(id);
        if (Objects.isNull(emendaParlamentar)) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)EmendaParlamentarConverter.toDTO((EmendaParlamentar)emendaParlamentar));
    }

    @PostMapping
    public ResponseEntity<EmendaParlamentar> save(@RequestBody EmendaParlamentarDTO emendaParlamentarDTO) throws URISyntaxException {
        return ResponseEntity.created((URI)new URI("")).body((Object)this.emendaParlamentarService.save(EmendaParlamentarConverter.toEntity((EmendaParlamentarDTO)emendaParlamentarDTO)));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<EmendaParlamentarDTO> update(@RequestBody EmendaParlamentarDTO emendaParlamentarDTO, @PathVariable(value="id") Long id) {
        EmendaParlamentar updated = this.emendaParlamentarService.update(EmendaParlamentarConverter.toEntity((EmendaParlamentarDTO)emendaParlamentarDTO));
        return ResponseEntity.ok((Object)EmendaParlamentarConverter.toDTO((EmendaParlamentar)updated));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable(value="id") Long id) {
        EmendaParlamentar emendaParlamentar = this.emendaParlamentarService.findOne(id);
        if (Objects.isNull(emendaParlamentar)) {
            return ResponseEntity.notFound().build();
        }
        this.emendaParlamentarService.delete(emendaParlamentar);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/report"})
    public ModelAndView exportListEmendas(HttpServletRequest request, HttpServletResponse response, @Valid EmendaParlamentarParams params, Pageable pageable) throws Throwable {
        EntidadeComprasDTO entidadeCompras;
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.emendaParlamentarService.findByParams(params, (Pageable)pageRequest);
        ReportParam reportParam = new ReportParam();
        if (Objects.nonNull(params.getEntidade()) && Objects.nonNull(entidadeCompras = this.entidadeComprasService.findOne((Long)params.getEntidade().get()))) {
            reportParam.setNomeEntidade(entidadeCompras.getNome());
        }
        reportParam.setReportTitle("Listagem das Emendas Parlamentares");
        reportParam.setClazzDTO(EmendaParlamentar.class);
        reportParam.setHeaderFields("Autoria,Tipo de Emenda,N\u00famero,Ano,Objeto,Fun\u00e7\u00e3o,Valor Previsto,Valor Realizado");
        reportParam.setFields("autoria,tipo,numero,exercicio,objeto,funcao,valorPrevisto,valorRealizado");
        float[] fieldsPerc = new float[]{0.8f, 1.0f, 0.8f, 0.8f, 2.0f, 1.8f, 0.8f, 0.8f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{20, 30, 20, 20, 500, 30, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @PostMapping(value={"/{id}/arquivo"})
    public ResponseEntity<EmendaParlamentar> salvarArquivo(@PathVariable(name="id") Long id, @RequestParam(value="files") MultipartFile file) throws IOException {
        return ResponseEntity.ok((Object)this.emendaParlamentarService.adicionarArquivoPublicacao(id, file));
    }

    @DeleteMapping(value={"/{id}/arquivo"})
    public ResponseEntity<EmendaParlamentar> deletarArquivo(@PathVariable(name="id") Long id) {
        return ResponseEntity.ok((Object)this.emendaParlamentarService.removerArquivoPublicacao(id));
    }
}

