/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.admportal.domain.dto.ConfiguracaoDTO;
import br.com.elotech.portaltransparencia.admportal.domain.dto.converter.ConfiguracaoConverter;
import br.com.elotech.portaltransparencia.contabportal.domain.Configuracao;
import br.com.elotech.portaltransparencia.contabportal.domain.ConfiguracaoInterface;
import br.com.elotech.portaltransparencia.contabportal.repository.ConfiguracaoRepository;
import br.com.elotech.protocolo.client.feign.ConsultaProcessoIntegracaoClientFeign;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ConfiguracaoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfiguracaoService.class);
    private final ConfiguracaoRepository configuracaoRepository;
    private final ConsultaProcessoIntegracaoClientFeign clientProcesso;
    private final Boolean isIntegradoOxy;

    public ConfiguracaoService(ConfiguracaoRepository configuracaoRepository, ConsultaProcessoIntegracaoClientFeign clientProcesso, @Value(value="${elotech.integradooxy:false}") Boolean isIntegradoOxy) {
        this.configuracaoRepository = configuracaoRepository;
        this.clientProcesso = clientProcesso;
        this.isIntegradoOxy = isIntegradoOxy;
    }

    public ConfiguracaoInterface getConfiguracao() {
        return this.configuracaoRepository.findByIdProjection(Long.valueOf(1L));
    }

    public ConfiguracaoDTO getConfiguracaoDTO() {
        ConfiguracaoDTO configuracaoDTO = ConfiguracaoConverter.interfaceToDTO((ConfiguracaoInterface)this.configuracaoRepository.findByIdProjection(Long.valueOf(1L)));
        configuracaoDTO.setIsIntegradoOxy(this.isIntegradoOxy);
        if (this.isIntegradoOxy.booleanValue()) {
            try {
                configuracaoDTO.setUrlProcessoExterno(this.clientProcesso.consultaUrlProcessoExterno());
            }
            catch (Exception e) {
                log.warn("Erro ao buscar informa\u00e7\u00f5es do Protocolo: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return configuracaoDTO;
    }

    public Optional<ConfiguracaoInterface> getConfiguracaoOptional() {
        if (Objects.nonNull(this.getConfiguracao())) {
            return Optional.of(this.getConfiguracao());
        }
        return Optional.empty();
    }

    public String getReponsavelLAI() {
        return this.configuracaoRepository.findByIdProjection(Long.valueOf(1L)).getResponsavelLAI();
    }

    public Configuracao save(Configuracao configuracao) {
        return (Configuracao)this.configuracaoRepository.save((Object)configuracao);
    }
}

