/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource.params;

import br.com.elotech.portaltransparencia.contabportal.resource.params.MovimentoGaragemParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class MovimentoGaragemParams {
    private Long entidade;
    private Long exercicio;
    private Long numero;
    private String data;
    private Long veiculo;
    private String letraPlaca;
    private String numeroPlaca;
    private String exportType;

    public Optional<String> getData() {
        return Optional.ofNullable(this.data);
    }

    public Optional<Long> getVeiculo() {
        return Optional.ofNullable(this.veiculo);
    }

    public Optional<String> getLetraPlaca() {
        return Optional.ofNullable(this.letraPlaca);
    }

    public Optional<String> getNumeroPlaca() {
        return Optional.ofNullable(this.numeroPlaca);
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addExercicio(params);
        this.addNumero(params);
        this.addData(params);
        this.addVeiculo(params);
        this.addLetraPlaca(params);
        this.addNumeroPlaca(params);
        return params;
    }

    private void addExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addNumero(MapSqlParameterSource params) {
        if (Objects.nonNull(this.numero)) {
            params.addValue("numero", (Object)this.numero, 2);
        }
    }

    private void addData(MapSqlParameterSource params) {
        if (Objects.nonNull(this.data)) {
            params.addValue("data", (Object)this.data, 91);
        }
    }

    private void addVeiculo(MapSqlParameterSource params) {
        if (Objects.nonNull(this.veiculo)) {
            params.addValue("veiculo", (Object)this.veiculo, 2);
        }
    }

    private void addLetraPlaca(MapSqlParameterSource params) {
        if (Objects.nonNull(this.letraPlaca)) {
            params.addValue("letraPlaca", (Object)SqlUtils.toSqlLike((String)this.letraPlaca), 12);
        }
    }

    private void addNumeroPlaca(MapSqlParameterSource params) {
        if (Objects.nonNull(this.numeroPlaca)) {
            params.addValue("numeroPlaca", (Object)SqlUtils.toSqlLike((String)this.numeroPlaca), 12);
        }
    }

    public br.com.elotech.oxy.adm.patrimonio.client.portal.MovimentoGaragemParams toOxyObject() {
        br.com.elotech.oxy.adm.patrimonio.client.portal.MovimentoGaragemParams oxyParam = new br.com.elotech.oxy.adm.patrimonio.client.portal.MovimentoGaragemParams();
        oxyParam.setEntidade(this.getEntidade());
        oxyParam.setExercicio(this.getExercicio());
        oxyParam.setNumero(this.getNumero());
        this.getData().ifPresent(arg_0 -> ((br.com.elotech.oxy.adm.patrimonio.client.portal.MovimentoGaragemParams)oxyParam).setData(arg_0));
        this.getVeiculo().ifPresent(arg_0 -> ((br.com.elotech.oxy.adm.patrimonio.client.portal.MovimentoGaragemParams)oxyParam).setVeiculo(arg_0));
        this.getLetraPlaca().ifPresent(arg_0 -> ((br.com.elotech.oxy.adm.patrimonio.client.portal.MovimentoGaragemParams)oxyParam).setLetraPlaca(arg_0));
        this.getNumeroPlaca().ifPresent(arg_0 -> ((br.com.elotech.oxy.adm.patrimonio.client.portal.MovimentoGaragemParams)oxyParam).setNumeroPlaca(arg_0));
        oxyParam.setExportType(this.getExportType());
        return oxyParam;
    }

    @Generated
    public static MovimentoGaragemParamsBuilder builder() {
        return new MovimentoGaragemParamsBuilder();
    }

    @Generated
    public String toString() {
        return "MovimentoGaragemParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", numero=" + this.getNumero() + ", data=" + this.getData() + ", veiculo=" + this.getVeiculo() + ", letraPlaca=" + this.getLetraPlaca() + ", numeroPlaca=" + this.getNumeroPlaca() + ", exportType=" + this.getExportType() + ")";
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getNumero() {
        return this.numero;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Generated
    public void setData(String data) {
        this.data = data;
    }

    @Generated
    public void setVeiculo(Long veiculo) {
        this.veiculo = veiculo;
    }

    @Generated
    public void setLetraPlaca(String letraPlaca) {
        this.letraPlaca = letraPlaca;
    }

    @Generated
    public void setNumeroPlaca(String numeroPlaca) {
        this.numeroPlaca = numeroPlaca;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MovimentoGaragemParams)) {
            return false;
        }
        MovimentoGaragemParams other = (MovimentoGaragemParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$numero = this.getNumero();
        Long other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !((Object)this$numero).equals(other$numero)) {
            return false;
        }
        Optional this$veiculo = this.getVeiculo();
        Optional other$veiculo = other.getVeiculo();
        if (this$veiculo == null ? other$veiculo != null : !((Object)this$veiculo).equals(other$veiculo)) {
            return false;
        }
        Optional this$data = this.getData();
        Optional other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Optional this$letraPlaca = this.getLetraPlaca();
        Optional other$letraPlaca = other.getLetraPlaca();
        if (this$letraPlaca == null ? other$letraPlaca != null : !((Object)this$letraPlaca).equals(other$letraPlaca)) {
            return false;
        }
        Optional this$numeroPlaca = this.getNumeroPlaca();
        Optional other$numeroPlaca = other.getNumeroPlaca();
        if (this$numeroPlaca == null ? other$numeroPlaca != null : !((Object)this$numeroPlaca).equals(other$numeroPlaca)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        return !(this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MovimentoGaragemParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : ((Object)$numero).hashCode());
        Optional $veiculo = this.getVeiculo();
        result = result * 59 + ($veiculo == null ? 43 : ((Object)$veiculo).hashCode());
        Optional $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Optional $letraPlaca = this.getLetraPlaca();
        result = result * 59 + ($letraPlaca == null ? 43 : ((Object)$letraPlaca).hashCode());
        Optional $numeroPlaca = this.getNumeroPlaca();
        result = result * 59 + ($numeroPlaca == null ? 43 : ((Object)$numeroPlaca).hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        return result;
    }

    @Generated
    public MovimentoGaragemParams() {
    }

    @Generated
    public MovimentoGaragemParams(Long entidade, Long exercicio, Long numero, String data, Long veiculo, String letraPlaca, String numeroPlaca, String exportType) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.numero = numero;
        this.data = data;
        this.veiculo = veiculo;
        this.letraPlaca = letraPlaca;
        this.numeroPlaca = numeroPlaca;
        this.exportType = exportType;
    }
}

