/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.Parametro;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ContaPagamentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.enums.ParametroEnum;
import br.com.elotech.portaltransparencia.contabportal.repository.LiquidacaoRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.impl.ParametroRepositoryImpl;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LiquidacaoParams;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class LiquidacaoSustentacaoRepositoryImpl
implements LiquidacaoRepository {
    private static final Long TIPO_DOC_NOTA_FISCAL = 1L;
    private static final Long TIPO_DOC_NOTA_FISCAL_ELETRONICO = 42L;
    private static final String PAGAS = "pagas";
    private static final String PAGAR = "pagar";
    private static final String SUPRIMENTOS_FUNDOS = "suprimentos-fundos";
    private static final String APTOS_PAGAMENTOS = "aptos-pagamentos";
    private static final String AGENDA_PAGAMENTO = "agenda-pagamento";
    private static final String ORDEM_CRONOLOGICA_PAGAMENTOS = "ordem-cronologica-pagamentos";
    private static final Logger LOGGER = LoggerFactory.getLogger(LiquidacaoSustentacaoRepositoryImpl.class);
    private static final String LIQUIDACAO_PAGAR = "db/sql/contab/liquidacao-pagar.sql";
    private static final String AGENDA_PREVISAO_PAGAMENTO = "db/sql/contab/agenda-previsao-pagamento.sql";
    private static final String LIQUIDACAO_PAGAS = "db/sql/contab/liquidacao-pagas.sql";
    private static final String CONTA_PAGAMENTO = "db/sql/contab/ordempagamento-liquidacao-conta.sql";
    private static final String REPLACE_ROW_NUM = "row_number() OVER (PARTITION BY XX.FONTERECURSO ORDER BY XX.FONTERECURSO, XX.DATA, XX.EMPENHO, XX.EXERCICIO)";
    private static final String ZERO = "0";
    private final DatasourceWrapper datasourceWrapper;
    private final EntidadeContabilidadeService entidadeService;
    private final ParametroRepositoryImpl parametroContabilRepository;

    @Autowired
    public LiquidacaoSustentacaoRepositoryImpl(DatasourceWrapper datasourceWrapper, EntidadeContabilidadeService entidadeService, ParametroRepositoryImpl parametroContabilRepository) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeService = entidadeService;
        this.parametroContabilRepository = parametroContabilRepository;
    }

    private String loadSQL(LiquidacaoParams params, String fileSql) {
        String sql = FileUtils.readResourceAsString((String)fileSql);
        if (SqlUtils.isH2((String)this.datasourceWrapper.getPlatform())) {
            sql = sql.replace(REPLACE_ROW_NUM, ZERO);
        }
        if (PAGAR.equals(params.getTipo()) || APTOS_PAGAMENTOS.equals(params.getTipo()) || AGENDA_PAGAMENTO.equals(params.getTipo())) {
            return this.sqlLiquidacoesPagar(params, sql);
        }
        if (PAGAS.equals(params.getTipo()) || SUPRIMENTOS_FUNDOS.equals(params.getTipo()) || ORDEM_CRONOLOGICA_PAGAMENTOS.equals(params.getTipo())) {
            return this.sqlLiquidacoesPagas(params, sql);
        }
        return "";
    }

    private StringBuilder buildWhere(LiquidacaoParams params) {
        StringBuilder where = new StringBuilder("");
        where.append(" WHERE 1 = 1 ");
        params.getEntidade().ifPresent(p -> where.append(" AND L.ENTIDADE ").append(this.entidadeService.resolveWhereSQL((Long)params.getEntidade().get())));
        if (params.filtrarPorExercicioDoEmpenho()) {
            params.getExercicio().ifPresent(p -> where.append(" AND L.EXERCICIO = ").append(params.getExercicio().get()));
        }
        params.getCnpjCpf().ifPresent(p -> where.append(" AND (F.CNPJ = '").append((String)params.getCnpjCpf().get()).append("')"));
        if (StringUtils.isNotEmpty((String)params.getNotaFiscal())) {
            where.append(" AND EXISTS (SELECT NF.ENTIDADE FROM ${db.contabilidade.schema}.LIQUIDACAODOCUMENTOS NF").append(" WHERE NF.ENTIDADE = L.ENTIDADE").append(" AND NF.EXERCICIO = L.EXERCICIO").append(" AND NF.EXERCICIOEMPENHO = L.ANODOCORIGEM").append(" AND NF.EMPENHO = L.NODOCORIGEM").append(" AND NF.NOLIQUIDACAO = L.NOLIQUIDACAO").append(" AND NF.NODOCUMENTO = '").append(params.getNotaFiscal()).append("')");
        }
        params.getEmpenho().ifPresent(e -> where.append(String.format(" AND E.EMPENHO = %d", e)));
        params.getFonteRecurso().ifPresent(e -> where.append(String.format(" AND E.FONTERECURSO = %d", Long.valueOf(e))));
        if (params.filtrarPorExercicioDoEmpenho() && !AGENDA_PAGAMENTO.equals(params.getTipo())) {
            where.append(String.format(" AND E.EXERCICIO = %d ", params.getExercicio().get()));
        }
        if (params.filtrarPorEmpenhosPendentes()) {
            where.append(String.format(" AND E.EXERCICIO < %d ", params.getExercicio().get()));
        }
        return where;
    }

    private void filterDataLiquidacoesPagar(LiquidacaoParams params, StringBuilder where) {
        if (Objects.nonNull(params.getDataInicial())) {
            where.append(" (XX.DATA >= :dataInicial) AND ");
        }
        if (Objects.nonNull(params.getDataFinal())) {
            where.append(" (XX.DATA <= :dataFinal) AND ");
        }
    }

    private String sqlLiquidacoesPagar(LiquidacaoParams params, String sql) {
        StringBuilder filtro = this.buildWhere(params);
        StringBuilder whereClause = new StringBuilder();
        if (params.getNome().isPresent()) {
            filtro.append(" AND ${db.contabilidade.schema}.tiraacento(UPPER( (${db.contabilidade.schema}.BUSCARAZAOSOCIALFORNECEDOR(F.FORNECEDOR, L.DATA) ))) like ${db.contabilidade.schema}.tiraacento('%");
            filtro.append(((String)params.getNome().get()).toUpperCase(LocaleContextHolder.getLocale()).replaceAll(" ", "%"));
            filtro.append("%') ");
        }
        if (params.getEmpenhoExercicio().isPresent()) {
            filtro.append(" AND E.EXERCICIO = :empenhoExercicio ");
        }
        if (APTOS_PAGAMENTOS.equals(params.getTipo())) {
            filtro.append(" AND E.TIPOLICITACAO <> '00' ");
        }
        if (Objects.nonNull(params.getIsCovid())) {
            filtro.append(" AND (E.MPCOVID19 = 'S' OR E.TIPO IN ('4','5','6') ) ");
        }
        this.FilterByFonteRecursoFundeb(params, filtro);
        filtro.append(" AND L.CONTABILIZADO = 'S' ");
        whereClause.append(" WHERE ");
        if (params.filtrarPorExercicioDoEmpenho() && AGENDA_PAGAMENTO.equals(params.getTipo())) {
            whereClause.append(String.format(" EXTRACT(YEAR FROM XX.DATA) = %d AND ", params.getExercicio().get()));
        }
        this.filterDataLiquidacoesPagar(params, whereClause);
        if (!params.getIsSomentePagos().booleanValue()) {
            whereClause.append(" XX.SALDO > 0.01 AND ");
        }
        if (params.getIsSomenteComOrdensNaoCanceladas().booleanValue()) {
            whereClause.append(" COALESCE(XX.CANCELADO, 'N') <> 'S' AND ");
        }
        return sql.replace("$[FILTRO]", filtro).replace("$[WHERE]", whereClause);
    }

    private String sqlLiquidacoesPagas(LiquidacaoParams params, String sql) {
        StringBuilder filtro = this.buildWhere(params);
        StringBuilder whereClause = new StringBuilder();
        whereClause.append(" WHERE 1 = 1 ");
        if (Objects.nonNull(params.getDataInicial())) {
            filtro.append(" AND (P.DATA >= :dataInicial)");
        }
        if (Objects.nonNull(params.getDataFinal())) {
            filtro.append(" AND (P.DATA <= :dataFinal)");
        }
        if (Objects.nonNull(params.getIsCovid())) {
            filtro.append(" AND (E.MPCOVID19 = 'S' OR E.TIPO IN ('4','5','6') ) ");
        }
        params.getExercicio().ifPresent(exercicio -> filtro.append(String.format(" AND P.EXERCICIO = %d ", exercicio)));
        if (SUPRIMENTOS_FUNDOS.equals(params.getTipo())) {
            filtro.append(" AND E.DESDOBRADESP = '96' ");
            filtro.append(" AND E.SUBDESDOBRAMENTO = '00' ");
        }
        if (params.getNome().isPresent()) {
            filtro.append(" AND ${db.contabilidade.schema}.tiraacento(UPPER( (${db.contabilidade.schema}.BUSCARAZAOSOCIALFORNECEDOR(F.FORNECEDOR, P.DATA)) )) like ${db.contabilidade.schema}.tiraacento('%");
            filtro.append(((String)params.getNome().get()).toUpperCase(LocaleContextHolder.getLocale()).replaceAll(" ", "%"));
            filtro.append("%') ");
        }
        params.getTipoContrato().ifPresent(p -> whereClause.append(" AND (XX.TIPOCONTRATO = '").append((String)params.getTipoContrato().get()).append("')"));
        params.getTipoContratoContabil().ifPresent(p -> whereClause.append(" AND (XX.TIPOCONTRATOCONTABIL = '").append((String)params.getTipoContratoContabil().get()).append("')"));
        this.FilterByFonteRecursoFundeb(params, filtro);
        return sql.replace("$[FILTRO]", filtro).replace("$[WHERE]", whereClause);
    }

    private void findNotasFiscais(List<LiquidacaoDTO> liquidacoes, LiquidacaoParams params) {
        for (LiquidacaoDTO liquidacao : liquidacoes) {
            StringBuilder sql = new StringBuilder();
            sql.append("select distinct nodocumento as notasFiscais from ${db.contabilidade.schema}.liquidacaodocumentos");
            sql.append(" where entidade = ").append(liquidacao.getEntidade());
            sql.append(" and exercicio = ").append(liquidacao.getExercicioLiquidacao());
            sql.append(" and exercicioempenho = ").append(liquidacao.getExercicio());
            sql.append(" and empenho = ").append(liquidacao.getEmpenho());
            sql.append(" and noliquidacao = ").append(liquidacao.getNoLiquidacao());
            sql.append(" and tipodocumento in (").append(TIPO_DOC_NOTA_FISCAL);
            sql.append(", " + TIPO_DOC_NOTA_FISCAL_ELETRONICO + ")");
            List notas = this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LiquidacaoDTO.class));
            StringBuilder nota = new StringBuilder();
            for (LiquidacaoDTO str : notas) {
                if (nota.length() > 0) {
                    nota.append('-');
                }
                nota.append(str.getNotasFiscais());
            }
            liquidacao.setNotasFiscais(nota.toString());
        }
    }

    private Page<LiquidacaoDTO> execFind(LiquidacaoParams params, String fileSql, Pageable pageable) {
        String sql = this.loadSQL(params, fileSql);
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)this.getOrder(params));
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        LOGGER.debug(query);
        LOGGER.debug(params.toString());
        List list = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LiquidacaoDTO.class));
        this.findNotasFiscais(list, params);
        return new PageImpl(list, pageable, this.quantidadeTotal(params, sql).longValue());
    }

    private String getOrder(LiquidacaoParams params) {
        if (AGENDA_PAGAMENTO.equals(params.getTipo()) || ORDEM_CRONOLOGICA_PAGAMENTOS.equals(params.getTipo())) {
            return "ORDER BY XX.EXERCICIO DESC, XX.DATA DESC, XX.EMPENHO DESC ";
        }
        String order = "XX.EXERCICIO DESC, XX.DATA DESC, XX.EMPENHO DESC, XX.FONTERECURSO";
        if (PAGAS.equals(params.getTipo()) || SUPRIMENTOS_FUNDOS.equals(params.getTipo())) {
            order = "XX.EXERCICIO DESC, XX.DATA DESC, XX.EMPENHO DESC";
        }
        if (APTOS_PAGAMENTOS.equals(params.getTipo())) {
            order = "XX.FONTERECURSO, XX.DATA, XX.EMPENHO, XX.EXERCICIO";
        }
        return "ORDER BY " + order;
    }

    private Long quantidadeTotal(LiquidacaoParams params, String sql) {
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT COUNT(*) AS TOTAL");
        sqlCount.append(" FROM (");
        sqlCount.append(sql);
        sqlCount.append(") X");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount.toString(), (SqlParameterSource)params.toJdbcParameter(), Long.class);
    }

    private LiquidacaoDTO getTotal(LiquidacaoParams params, String fileSql) {
        String sql = this.loadSQL(params, fileSql);
        StringBuilder sqlTotal = new StringBuilder();
        sqlTotal.append("SELECT SUM(X.VALOR) AS VALOR, SUM(X.SALDO) AS SALDO");
        sqlTotal.append(" FROM (");
        sqlTotal.append(sql);
        sqlTotal.append(") X");
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(LiquidacaoDTO.class);
        return this.datasourceWrapper.getJdbcTemplate().query(sqlTotal.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)rowMapper).stream().findFirst().orElse(new LiquidacaoDTO());
    }

    public Page<LiquidacaoDTO> findLiquidacoesAPagar(LiquidacaoParams params, Pageable pageable) {
        return this.execFind(params, LIQUIDACAO_PAGAR, pageable);
    }

    public Page<LiquidacaoDTO> findAgendaPrevisaoPagamento(LiquidacaoParams params, Pageable pageable) {
        return this.execFind(params, AGENDA_PREVISAO_PAGAMENTO, pageable);
    }

    public Page<LiquidacaoDTO> findLiquidacoesPagas(LiquidacaoParams params, Pageable pageable) {
        return this.execFind(params, LIQUIDACAO_PAGAS, pageable);
    }

    public LiquidacaoDTO findLiquidacoesPagasTotal(LiquidacaoParams params) {
        return this.getTotal(params, LIQUIDACAO_PAGAS);
    }

    public LiquidacaoDTO findLiquidacoesAPagarTotal(LiquidacaoParams params) {
        return this.getTotal(params, LIQUIDACAO_PAGAR);
    }

    public ContaPagamentoDTO findContaPagamento(LiquidacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)CONTA_PAGAMENTO);
        LOGGER.debug(sql);
        LOGGER.debug(params.toString());
        List list = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ContaPagamentoDTO.class));
        return list.stream().findFirst().orElse(new ContaPagamentoDTO());
    }

    private void FilterByFonteRecursoFundeb(LiquidacaoParams params, StringBuilder filtro) {
        if (Objects.nonNull(params.getIsFundeb())) {
            String campo;
            Parametro paramNivel = this.parametroContabilRepository.findByEntidadeExercicioModuloAndCodigo((Long)params.getEntidade().get(), (Long)params.getExercicio().get(), ModuloEnum.MODULO_SISCOP.getValue(), ParametroEnum.PARAM_NIVEL_FONTERECURSO_FUNDEB.getCodigo());
            switch (paramNivel.getValor()) {
                case "1": {
                    campo = "codigo";
                    break;
                }
                case "2": {
                    campo = "codigofontepadraotce";
                    break;
                }
                case "3": {
                    campo = "codigoorigem";
                    break;
                }
                case "4": {
                    campo = "codigoaplicacao";
                    break;
                }
                case "5": {
                    campo = "codigodesdobramento";
                    break;
                }
                case "6": {
                    campo = "identificadoruso";
                    break;
                }
                case "7": {
                    campo = "codigogrupo";
                    break;
                }
                case "8": {
                    campo = "codigodestinacao";
                    break;
                }
                case "9": {
                    campo = "codigodetalhamento";
                    break;
                }
                default: {
                    campo = "codigo";
                }
            }
            Parametro paramValor = this.parametroContabilRepository.findByEntidadeExercicioModuloAndCodigo((Long)params.getEntidade().get(), (Long)params.getExercicio().get(), ModuloEnum.MODULO_SISCOP.getValue(), ParametroEnum.PARAM_VALOR_FONTERECURSO_FUNDEB.getCodigo());
            filtro.append(" AND FRP." + campo + " in (" + paramValor.getValor().replace(";", ",") + ")");
        }
    }
}

