/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AvaliacaoPPAProgramaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.AvaliacaoPPARepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AvaliacaoPPAParams;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AvaliacaoPPARepositorySustentacaoImpl
implements AvaliacaoPPARepository {
    private static final String REPLACE_RESULTADO_OBTIDO = "MAX(ACAOPPA.RESULTADOOBTIDO) OVER (PARTITION BY TB1.PROJETO)";
    private static final String REPLACE_UNIDADE_MEDIDA = "MAX(ACAOPPA.DSUNIDADEMEDIDA) OVER (PARTITION BY TB1.PROJETO)";
    private static final String ZERO = "0";
    private static final Logger LOGGER = LoggerFactory.getLogger(AvaliacaoPPARepositorySustentacaoImpl.class);
    private static final String AVALIACAO_PPA = "db/sql/contab/avaliacao-ppa.sql";
    private static final String FILTROS = "$[filtros]";
    private final DatasourceWrapper datasourceWrapper;
    private final Environment environment;

    @Autowired
    public AvaliacaoPPARepositorySustentacaoImpl(DatasourceWrapper datasourceWrapper, Environment environment) {
        this.datasourceWrapper = datasourceWrapper;
        this.environment = environment;
    }

    public List<AvaliacaoPPAProgramaDTO> findAvaliacoesPPA(AvaliacaoPPAParams params) {
        String sql = FileUtils.readResourceAsString((String)AVALIACAO_PPA);
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"!production"}))) {
            sql = sql.replace(REPLACE_RESULTADO_OBTIDO, ZERO);
            sql = sql.replace(REPLACE_UNIDADE_MEDIDA, ZERO);
        }
        sql = params.getDescricaoProjeto().isPresent() ? sql.replace(FILTROS, this.addFiltroDescricaoProjeto((String)params.getDescricaoProjeto().get())) : sql.replace(FILTROS, "");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AvaliacaoPPAProgramaDTO.class));
    }

    private String addFiltroDescricaoProjeto(String descricaoProjeto) {
        return "AND (SELECT UPPER(DESCRICAO) FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA WHERE ENTIDADE = A.ENTIDADE AND EXERCICIO = A.EXERCICIO AND ORDEM = 6 AND CODIGO = SUBSTR(A.PROGRAMATICA, 15, 4)) like upper('%" + descricaoProjeto + "%')";
    }
}

