/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioEmpenhoDTO;
import br.com.elotech.portaltransparencia.web.rest.params.EmpenhoParams;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class PatrimonioMovimentoEmpenhoRepository {
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public PatrimonioMovimentoEmpenhoRepository(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<PatrimonioEmpenhoDTO> getPatrimonioEmpenho(EmpenhoParams params) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT DISTINCT EXERCICIO, EMPENHO FROM ( ");
        sql.append("    SELECT ME.EMPENHOANO AS EXERCICIO, ME.EMPENHO  ");
        sql.append("      FROM ${db.contabilidade.schema}.PAT_MOVIMENTOITEM MI ");
        sql.append("      LEFT OUTER JOIN ${db.contabilidade.schema}.PAT_MOVIMENTOEMPENHO ME ");
        sql.append("        ON MI.ENTIDADE = ME.ENTIDADE ");
        sql.append("       AND MI.EXERCICIO = ME.EXERCICIO ");
        sql.append("       AND MI.CODIGO = ME.CODIGO ");
        sql.append("     WHERE ME.ENTIDADE = ").append(params.getEntidade());
        sql.append("       AND MI.TIPO = '").append(params.getTipoBem()).append("' ");
        sql.append("       AND MI.CHAPA = '").append(params.getChapaBem()).append("' ");
        sql.append("     UNION ALL ");
        sql.append("    SELECT A.EMPENHOANO EXERCICIO, A.EMPENHO ");
        sql.append("      FROM ${db.contabilidade.schema}.PAT_BEMXEMPENHO A ");
        sql.append("     WHERE A.ENTIDADE = ").append(params.getEntidade());
        sql.append("       AND A.TIPO = '").append(params.getTipoBem()).append("' ");
        sql.append("       AND A.CHAPA = '").append(params.getChapaBem()).append("' ");
        sql.append("     ) EMPENHO ");
        return this.datasourceWrapper.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(PatrimonioEmpenhoDTO.class));
    }
}

