/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.NotaExtraorcamentariaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.NotaExtraorcamentariaItemDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.NotaExtraorcamentariaParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class NotaExtraorcamentariaRepository {
    private static final String NOTA_EXTRA_ORCAMENTARIA = "db/sql/contab/notaExtraorcamentaria.sql";
    private static final String NOTA_EXTRA_ORCAMENTARIA_ITENS = "db/sql/contab/notaExtraorcamentariaItens.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public NotaExtraorcamentariaRepository(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<NotaExtraorcamentariaDTO> findNotasExtraorcamentarias(NotaExtraorcamentariaParams params, Pageable pageable) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)NOTA_EXTRA_ORCAMENTARIA));
        sql.append(this.montaFiltro(params));
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)" ORDER BY E.NOEXTRAORCAMENTARIO DESC ");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        List lista = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(NotaExtraorcamentariaDTO.class));
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(SqlUtils.createSQLCount((String)sql.toString()), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        return new PageImpl(lista, pageable, total.longValue());
    }

    public NotaExtraorcamentariaDTO findNotaExtraorcamentaria(NotaExtraorcamentariaParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)NOTA_EXTRA_ORCAMENTARIA));
        sql.append(this.montaFiltro(params));
        return (NotaExtraorcamentariaDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(NotaExtraorcamentariaDTO.class));
    }

    public List<NotaExtraorcamentariaItemDTO> findNotaExtraorcamentariaItens(NotaExtraorcamentariaParams params) {
        String sql = FileUtils.readResourceAsString((String)NOTA_EXTRA_ORCAMENTARIA_ITENS);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(NotaExtraorcamentariaItemDTO.class));
    }

    private String montaFiltro(NotaExtraorcamentariaParams params) {
        StringBuilder where = new StringBuilder();
        where.append(SqlUtils.andEqual((String)"E.NOEXTRAORCAMENTARIO", (Long)params.getNoExtraorcamentario()));
        where.append(SqlUtils.andLike((String)"${db.contabilidade.schema}", (String)"F.NOME", (String)params.getNome()));
        where.append(SqlUtils.andLike((String)"${db.contabilidade.schema}", (String)"F.CNPJ", (String)params.getCnpjCpf()));
        if (Objects.nonNull(params.getDataInicial())) {
            where.append(" AND E.DATA >= :dataInicial ");
        }
        if (Objects.nonNull(params.getDataFinal())) {
            where.append(" AND E.DATA <= :dataFinal ");
        }
        return where.toString();
    }
}

