/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.CentralPagamentoDTO;
import br.com.elotech.contabilidade.client.dto.ExercicioDTO;
import br.com.elotech.contabilidade.client.dto.PagamentoDTO;
import br.com.elotech.core.utils.NumberUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class EmpenhoPagamentoDTO {
    private Long entidade;
    private Long exercicio;
    private Long empenho;
    private String unidadeOrcamentaria;
    private Long exercicioPagamento;
    private Long noPagamento;
    private Long exercicioLiquidacao;
    private Long noLiquidacao;
    private LocalDate data;
    private BigDecimal valor;
    private String situacao;
    private Long banco;
    private String agencia;
    private String conta;
    private String tipoDocumento;
    private String nroDocumento;
    private BigDecimal valorRetido;

    public EmpenhoPagamentoDTO(PagamentoDTO pagamento) {
        ExercicioDTO exercicioPag = pagamento.getCentralPagamento().getExercicio();
        CentralPagamentoDTO centralPagamento = pagamento.getCentralPagamento();
        this.entidade = exercicioPag.getEntidade().getId();
        this.exercicio = exercicioPag.getExercicio();
        this.empenho = pagamento.getLiquidacao().getEmpenho().getNumeroEmpenho();
        this.noPagamento = centralPagamento.getNumeroCentral();
        this.exercicioPagamento = exercicioPag.getExercicio();
        this.noLiquidacao = pagamento.getLiquidacao().getNumeroLiquidacao();
        this.exercicioLiquidacao = pagamento.getLiquidacao().getExercicioAno();
        this.data = pagamento.getCentralPagamento().getData();
        this.valor = pagamento.getSaldoPago();
        this.valorRetido = pagamento.getSaldoPagoAnulado();
        this.tipoDocumento = centralPagamento.getTipoDocumento().getDescricao();
        this.nroDocumento = centralPagamento.getNumeroDocumento();
        Optional.ofNullable(centralPagamento.getContaBancaria()).ifPresent(c -> {
            this.banco = c.getAgencia().getBanco().getCodigo();
            this.agencia = c.getAgencia().getCodigo();
            this.conta = c.getConta();
        });
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public Long getEmpenho() {
        return this.empenho;
    }

    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    public String getUnidadeOrcamentaria() {
        return this.unidadeOrcamentaria;
    }

    public void setUnidadeOrcamentaria(String unidadeOrcamentaria) {
        this.unidadeOrcamentaria = unidadeOrcamentaria;
    }

    public Long getExercicioPagamento() {
        return this.exercicioPagamento;
    }

    public void setExercicioPagamento(Long exercicioPagamento) {
        this.exercicioPagamento = exercicioPagamento;
    }

    public Long getNoPagamento() {
        return this.noPagamento;
    }

    public void setNoPagamento(Long noPagamento) {
        this.noPagamento = noPagamento;
    }

    public Long getExercicioLiquidacao() {
        return this.exercicioLiquidacao;
    }

    public void setExercicioLiquidacao(Long exercicioLiquidacao) {
        this.exercicioLiquidacao = exercicioLiquidacao;
    }

    public Long getNoLiquidacao() {
        return this.noLiquidacao;
    }

    public void setNoLiquidacao(Long noLiquidacao) {
        this.noLiquidacao = noLiquidacao;
    }

    public LocalDate getData() {
        return this.data;
    }

    public void setData(LocalDate data) {
        this.data = data;
    }

    public BigDecimal getValor() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valor);
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public Long getBanco() {
        return this.banco;
    }

    public void setBanco(Long banco) {
        this.banco = banco;
    }

    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    public String getConta() {
        return this.conta;
    }

    public void setConta(String conta) {
        this.conta = conta;
    }

    public String getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(String tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    public String getNroDocumento() {
        return this.nroDocumento;
    }

    public void setNroDocumento(String nroDocumento) {
        this.nroDocumento = nroDocumento;
    }

    public BigDecimal getValorRetido() {
        return this.valorRetido;
    }

    public void setValorRetido(BigDecimal valorRetido) {
        this.valorRetido = valorRetido;
    }

    @Generated
    public EmpenhoPagamentoDTO() {
    }
}

