/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PessoaAdmDTO;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindPessoaAdmParams;
import br.com.elotech.portaltransparencia.comprasportal.service.PessoaAdmService;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/pessoaadm"})
public class PessoaAdmResource {
    private final PessoaAdmService pessoaAdmService;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;

    public PessoaAdmResource(PessoaAdmService pessoaAdmService, EntidadeContabilidadeRepository entidadeRepository, BaseExport baseExport, ElotechProperties elotechProperties) {
        this.pessoaAdmService = pessoaAdmService;
        this.entidadeRepository = entidadeRepository;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
    }

    @GetMapping
    ResponseEntity<Page<PessoaAdmDTO>> findPessoasAdm(@Valid FindPessoaAdmParams params, Pageable pageable) {
        return ResponseEntity.ok((Object)this.pessoaAdmService.findPessoasAdm(params, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findAllExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=false) Long entidade, @Valid FindPessoaAdmParams params, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.pessoaAdmService.findPessoasAdm(params, (Pageable)pageRequest);
        ReportParam reportParam = new ReportParam();
        if (Objects.nonNull(entidade)) {
            Optional entidadeObj = this.entidadeRepository.findById((Object)entidade);
            entidadeObj.ifPresent(entidadeAux -> reportParam.setNomeEntidade(entidadeAux.getNome()));
        }
        reportParam.setReportTitle("Fornecedores Suspensos");
        reportParam.setClazzDTO(PessoaAdmDTO.class);
        String headerFields = "Nome, CNPJ/CPF, Dt. In\u00edcio Suspens\u00e3o, Dt. Final Suspens\u00e3o, Observa\u00e7\u00e3o";
        String fields = "nome,cnpjCpf,dataIniSuspensao,dataFinSuspensao,observacao";
        float[] fieldsPerc = new float[]{1.8f, 1.8f, 0.7f, 0.7f, 1.8f};
        int[] fieldTab = new int[]{100, 100, 15, 15, 100};
        reportParam.setHeaderFields(headerFields);
        reportParam.setFields(fields);
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

