/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.AlvaraDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AlvaraParams;
import br.com.elotech.portaltransparencia.aiseportal.service.AlvaraService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/alvara"})
public class AlvaraResource {
    private final AlvaraService service;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    @Autowired
    public AlvaraResource(AlvaraService service, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.service = service;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping
    public ResponseEntity<Page<AlvaraDTO>> findAlvaras(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, AlvaraParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.findAlvaras(params, pageable));
    }

    @GetMapping(value={"/detalhe"})
    public ResponseEntity<AlvaraDTO> findAlvara(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, AlvaraParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.findAlvara(params));
    }

    @GetMapping(value={"/detalhe/arquivos"})
    public ResponseEntity<List<AlvaraDTO>> findAlvaraArquivos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, AlvaraParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.findAlvaraArquivos(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findObrasExport(HttpServletRequest request, HttpServletResponse response, @Valid AlvaraParams params, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.service.findAlvaras(params, (Pageable)pageRequest);
        Entidade entidade = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidade.getNome());
        reportParam.setReportTitle("Alvaras");
        reportParam.setClazzDTO(AlvaraDTO.class);
        reportParam.setHeaderFields("Raz\u00e3o Social,Nome Fantasia,CPNJ/CPF");
        reportParam.setFields("nome,nomeFantasia,cnpjCpf");
        float[] fieldsPerc = new float[]{1.2f, 1.2f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{200, 200, 100};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/arquivo/{id}"})
    public void getArquivo(@PathVariable Long id, HttpServletResponse response) throws IOException {
        ArquivoDTO arquivo = this.service.getArquivo(id);
        String nomeGenerico = "Arquivo" + id;
        if (!Objects.nonNull(arquivo) || !Objects.nonNull(arquivo.getArquivoFisico())) {
            throw RestException.notFound((String)"Arquivo n\u00e3o encontrado!");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo.getArquivoFisico(), (String)nomeGenerico, (String)arquivo.getExtensao());
    }
}

