/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.portaltransparencia.aiseportal.domain.ParametroEntidade;
import br.com.elotech.portaltransparencia.aiseportal.repository.ParametroEntidadeRepository;
import br.com.elotech.portaltransparencia.aiseportal.repository.impl.CedidoRepositoryImpl;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ParametroEntidadeRepositoryImpl
implements ParametroEntidadeRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CedidoRepositoryImpl.class);
    private final DatasourceWrapper datasourceWrapper;

    public ParametroEntidadeRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public ParametroEntidade findParametroPorEntidade(Long entidade, String parametro) {
        StringBuilder query = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade, 2);
        params.addValue("parametro", (Object)parametro, 12);
        query.append(" SELECT ENTIDADE, MODULO, PARAMETRO, VALOR, DESCRICAO ");
        query.append(" FROM ${db.aise.schema}.PARAMETROENTIDADE ");
        query.append(" WHERE ENTIDADE = :entidade ");
        query.append(" AND MODULO = '25' ");
        query.append(" AND PARAMETRO = :parametro ");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
        }
        try {
            return (ParametroEntidade)this.datasourceWrapper.getJdbcTemplate().queryForObject(query.toString(), (SqlParameterSource)params, (RowMapper)new BeanPropertyRowMapper(ParametroEntidade.class));
        }
        catch (EmptyResultDataAccessException ex) {
            return null;
        }
    }
}

