/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.saude.service;

import br.com.elotech.portaltransparencia.saude.domain.dto.AtaDTO;
import br.com.elotech.portaltransparencia.saude.domain.dto.ConselhoMunicipalDTO;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class ConselhoService {
    private final RestTemplate restTemplate;
    @Value(value="${elotech.sistemaSaude.url:}")
    private String urlSaude;
    @Value(value="${elotech.sistemaSaude.enabled:false}")
    private Boolean sistemaSaude;

    public ConselhoService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public List<ConselhoMunicipalDTO> findConselhos(Long exercicio) {
        if (Boolean.FALSE.equals(this.sistemaSaude) || this.urlSaude.isEmpty()) {
            return new ArrayList<ConselhoMunicipalDTO>();
        }
        URI uri = URI.create(String.format("%s/WebSocialSaude/rest/saude/conselhos/exercicio/%d", this.urlSaude, exercicio));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, ConselhoMunicipalDTO[].class);
            return Arrays.asList(Objects.requireNonNull((ConselhoMunicipalDTO[])responseEntity.getBody()));
        }
        catch (HttpClientErrorException e) {
            return new ArrayList<ConselhoMunicipalDTO>();
        }
    }

    public List<ConselhoMunicipalDTO> findConselho(Long id) {
        if (Boolean.FALSE.equals(this.sistemaSaude) || this.urlSaude.isEmpty()) {
            return new ArrayList<ConselhoMunicipalDTO>();
        }
        URI uri = URI.create(String.format("%s/WebSocialSaude/rest/saude/conselhos/id/%d", this.urlSaude, id));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, ConselhoMunicipalDTO[].class);
            return Arrays.asList(Objects.requireNonNull((ConselhoMunicipalDTO[])responseEntity.getBody()));
        }
        catch (HttpClientErrorException e) {
            return new ArrayList<ConselhoMunicipalDTO>();
        }
    }

    public AtaDTO getArquivo(Long id) {
        URI uri = URI.create(String.format("%s/WebSocialSaude/rest/saude/conselhos/atas/%d", this.urlSaude, id));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, AtaDTO[].class);
        List<AtaDTO> ata = Arrays.asList(Objects.requireNonNull((AtaDTO[])responseEntity.getBody()));
        return ata.get(0);
    }
}

