/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.portaltransparencia.admportal.domain.NotaExplicativa;
import br.com.elotech.portaltransparencia.admportal.repository.NotaExplicativaRepository;
import br.com.elotech.portaltransparencia.admportal.resource.params.NotaExplicativaParams;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class NotaExplicativaService
extends CrudService<NotaExplicativa, Long> {
    @Autowired
    private final NotaExplicativaRepository notaExplicativaRepository;

    public NotaExplicativaService(NotaExplicativaRepository notaExplicativaRepository) {
        this.notaExplicativaRepository = notaExplicativaRepository;
    }

    public List<NotaExplicativa> findNotaExplicativaAndExercicio(Long entidade, Long exercicio) {
        return this.notaExplicativaRepository.findByEntidadeAndExercicio(entidade, exercicio);
    }

    public Page<NotaExplicativa> findNotaExplicativa(NotaExplicativaParams params, Pageable pageable) {
        if (Objects.nonNull(params.getExercicio())) {
            return this.notaExplicativaRepository.findByEntidadeAndExercicio(params.getEntidade(), params.getExercicio(), pageable);
        }
        return this.notaExplicativaRepository.findByEntidade(params.getEntidade(), pageable);
    }

    public NotaExplicativa save(NotaExplicativa notaExplicativa) {
        return (NotaExplicativa)this.notaExplicativaRepository.save((Object)notaExplicativa);
    }

    public NotaExplicativa update(NotaExplicativa notaExplicativa) {
        NotaExplicativa notaFound = (NotaExplicativa)this.notaExplicativaRepository.findOne((Object)notaExplicativa.getId());
        if (Objects.isNull(notaFound)) {
            throw RestException.notFound();
        }
        notaFound.setEntidade(notaExplicativa.getEntidade());
        notaFound.setExercicio(notaExplicativa.getExercicio());
        notaFound.setNotaExplicativa(notaExplicativa.getNotaExplicativa());
        notaFound.setPath(notaExplicativa.getPath());
        return (NotaExplicativa)this.notaExplicativaRepository.save((Object)notaFound);
    }

    public void delete(NotaExplicativa notaExplicativa) {
        this.notaExplicativaRepository.delete((Object)notaExplicativa);
    }
}

