/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.mapper;

import br.com.elotech.contabilidade.client.dto.EmpenhoDTO;
import br.com.elotech.contabilidade.client.dto.EmpenhoItemDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.ItemEmpenho;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ComprasDiretaDTO;
import br.com.elotech.portaltransparencia.utils.MaskFormatterUtils;
import java.util.Objects;
import java.util.function.Function;

public class ComprasDiretaToDTO
implements Function<ItemEmpenho, ComprasDiretaDTO> {
    @Override
    public ComprasDiretaDTO apply(ItemEmpenho item) {
        ComprasDiretaDTO dto = new ComprasDiretaDTO();
        dto.setEntidade(item.getId().getEmpenho().getId().getEntidade());
        dto.setExercicio(item.getId().getEmpenho().getId().getExercicio());
        dto.setEmpenho(item.getId().getEmpenho().getId().getEmpenho());
        dto.setUnidadeOrcamentaria(item.getId().getEmpenho().getId().getUnidadeOrcamentaria());
        dto.setData(item.getId().getEmpenho().getData());
        dto.setNumeroProcesso(item.getId().getEmpenho().getNumeroProcesso());
        dto.setOrdem(item.getId().getOrdem());
        dto.setItem(item.getEspecificacao());
        dto.setQuantidade(item.getQuantidade());
        dto.setValorTotal(item.getValorTotal());
        dto.setValorUnitario(item.getValorUnitario());
        dto.setUnidadeItem(item.getUnidadeItem());
        if (Objects.nonNull(item.getId().getEmpenho().getTipoLicitacao())) {
            dto.setTipoLicitacao(item.getId().getEmpenho().getTipoLicitacao().getId());
        }
        if (Objects.nonNull(item.getId().getEmpenho().getFornecedor())) {
            dto.setFornecedor(item.getId().getEmpenho().getFornecedor().getNome());
            dto.setCnpj(MaskFormatterUtils.configMaskCnpjCpf((String)item.getId().getEmpenho().getFornecedor().getCnpj()));
        }
        return dto;
    }

    public static ComprasDiretaDTO apply(EmpenhoItemDTO item, EmpenhoDTO empenhoDTO) {
        ComprasDiretaDTO dto = new ComprasDiretaDTO();
        dto.setEntidade(empenhoDTO.getExercicio().getEntidade().getId());
        dto.setExercicio(empenhoDTO.getExercicio().getExercicio());
        dto.setEmpenho(empenhoDTO.getNumeroEmpenho());
        dto.setData(empenhoDTO.getData());
        dto.setNumeroProcesso(empenhoDTO.getNumeroEmpenho().toString());
        dto.setOrdem(item.getSequencia());
        dto.setItem(item.getItem().getDescricao());
        dto.setQuantidade(item.getQuantidade());
        dto.setValorTotal(item.getValorUnitario().multiply(item.getQuantidade()));
        dto.setValorUnitario(item.getValorUnitario());
        if (Objects.nonNull(item.getItem().getUnidadeMedida())) {
            dto.setUnidadeItem(item.getItem().getUnidadeMedida().getDescricao());
        }
        if (Objects.nonNull(empenhoDTO.getTipoLicitacao())) {
            dto.setTipoLicitacao(empenhoDTO.getTipoLicitacao().getCodigo().toString());
        }
        if (Objects.nonNull(empenhoDTO.getCredor())) {
            dto.setFornecedor(empenhoDTO.getCredor().getNome());
            dto.setCnpj(empenhoDTO.getCredor().getCnpjCpf());
        }
        return dto;
    }
}

