SELECT X.CODIGO,
       X.DESCRICAO,
       X.VALORDECRETO + (SELECT SUM(D.VALORPREVISTO) 
                           FROM ${db.contabilidade.schema}.DESPESA D
                          WHERE D.ENTIDADE = X.ENTIDADE
                            AND D.EXERCICIO = X.EXERCICIO
                            AND SUBSTR(D.PROGRAMATICA,X.POSICAO,X.TAMANHO) = X.CODIGO
                            AND D.MOVSN='S') AS VALORORCADO,
       X.VALOREMPENHADO,
       X.VALORLIQUIDADO,
       X.VALORRETIDO,
       X.VALORPAGO
FROM (                           
SELECT 
  A.ENTIDADE,
  A.EXERCICIO,
  NIVEL.POSICAO,
  NIVEL.TAMANHO,
  SUBSTR(A.PROGRAMATICA,NIVEL.POSICAO,NIVEL.TAMANHO) AS codigo, 
  MAX((SELECT DISTINCT P.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA P
     WHERE P.ENTIDADE = A.ENTIDADE  
       AND P.EXERCICIO = A.EXERCICIO  
       AND P.MODELODESPESA = A.MODELODESPESA 
       AND P.TIPO = NIVEL.TIPO  
       AND P.ORDEM = NIVEL.ORDEM  
       AND SUBSTR(A.PROGRAMATICA,NIVEL.POSICAO,NIVEL.TAMANHO) = P.CODIGO)) AS descricao, 
   COALESCE(SUM(D.VALORSUPLEMENTACAO - D.VALORESTSUPLEMENTACAO -  
                D.VALORREDUCAO + D.VALORESTREDUCAO),0) AS valorDecreto,  
   COALESCE(SUM(D.VALOREMPENHO-D.VALORANULACAOEMPENHO+D.VALORESTANULACAOEMPENHO),0) AS valorEmpenhado,  
   COALESCE(SUM(D.VALORLIQUIDACAO-D.VALORESTLIQUIDACAO),0) AS valorLiquidado,  
   COALESCE(SUM(D.VALORRETENCAO),0) AS valorRetido,
   COALESCE(SUM(D.VALORPAGAMENTO-D.VALORESTPAGAMENTO),0) AS valorPago  
   FROM ${db.contabilidade.schema}.DESPESA A
   LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA NIVEL
     ON A.MODELODESPESA = NIVEL.MODELODESPESA  
   LEFT OUTER JOIN ${db.contabilidade.schema}.DESPESAMENSAL D
     ON A.ENTIDADE = D.ENTIDADE  
    AND A.EXERCICIO = D.EXERCICIO  
    AND A.PROGRAMATICA = D.PROGRAMATICA 
    AND A.FONTERECURSO = D.FONTERECURSO  
  WHERE A.ENTIDADE = ?
  AND A.EXERCICIO = ?
  AND NIVEL.NIVELLEI = ?
  AND NIVEL.TIPO = ?
  AND A.MOVSN = 'S'
  GROUP BY A.ENTIDADE, A.EXERCICIO, NIVEL.POSICAO, NIVEL.TAMANHO, SUBSTR(A.PROGRAMATICA,NIVEL.POSICAO,NIVEL.TAMANHO)
) X  
ORDER BY X.CODIGO
