SELECT P.ENTIDADE,
       P.EXERCICIO,
       P.CODIGOUNIDADE,
       D.DESCRICAO AS UNIDADEDESCRICAO,
       P.PLANOCONTRATACAO,
       P.USUARIO,
       P.CODCONTRATACAOFUTURA,
       P.NOMECONTRATACAOFUTURA,
       P.DATAPCA,
       P.STATUS,
       CASE
            WHEN P.STATUS = 'F' THEN 'Finalizado'
            ELSE 'Aberto'
       END AS STATUSDESCRICAO,
       P.DEMONSTRAPORTAL
  FROM ${db.compras.schema}.CLPLANOCONTRATACAO P
  LEFT JOIN ${db.contabilidade.schema}.DESPESA D
         ON D.ENTIDADE  = P.ENTIDADE
        AND D.EXERCICIO = P.EXERCICIO
        AND SUBSTR (D.PROGRAMATICA,1,2) = P.CODIGOUNIDADE
        AND SUBSTR (D.PROGRAMATICA,3,3) = '000'
  WHERE P.DEMONSTRAPORTAL = 'S'
    AND P.STATUS = 'F'