/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.service.impl;

import br.com.elotech.portaltransparencia.protocportal.dto.EstatisticaDTO;
import br.com.elotech.portaltransparencia.protocportal.dto.RelatorioAnualEstatisticaDTO;
import br.com.elotech.portaltransparencia.protocportal.dto.SerieItemDTO;
import br.com.elotech.portaltransparencia.protocportal.repository.EstatisticaRepository;
import br.com.elotech.portaltransparencia.protocportal.resource.params.EstatisticaParams;
import br.com.elotech.portaltransparencia.protocportal.service.EstatisticaService;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class EstatisticaServiceImpl
implements EstatisticaService {
    private final EstatisticaRepository repository;

    public EstatisticaServiceImpl(EstatisticaRepository repository) {
        this.repository = repository;
    }

    public BigDecimal getMediaResposta(EstatisticaParams params) {
        return this.repository.getMediaResposta(params);
    }

    public List<EstatisticaDTO> findEstatisticas(EstatisticaParams params) {
        return this.repository.findEstatisticas(params);
    }

    public List<SerieItemDTO> findProcessosPorGenero(EstatisticaParams params) {
        return this.repository.findProcessosPorGenero(params);
    }

    public List<SerieItemDTO> findProcessosPorIdade(EstatisticaParams params) {
        return this.repository.findProcessosPorIdade(params);
    }

    public List<SerieItemDTO> findProcessosPorEscolaridade(EstatisticaParams params) {
        return this.repository.findProcessosPorEscolaridade(params);
    }

    public List<RelatorioAnualEstatisticaDTO> findRelatorioAnual(EstatisticaParams params) {
        List estatistica = this.repository.findEstatisticas(params);
        Integer pedidos = estatistica.stream().reduce(0, (a, b) -> Math.toIntExact((long)a.intValue() + b.getPedidos()), Integer::sum);
        Integer atendidos = estatistica.stream().reduce(0, (a, b) -> Math.toIntExact((long)a.intValue() + b.getAtendidos()), Integer::sum);
        Integer cancelados = estatistica.stream().reduce(0, (a, b) -> Math.toIntExact((long)a.intValue() + b.getCancelados()), Integer::sum);
        Integer indeferidos = estatistica.stream().reduce(0, (a, b) -> Math.toIntExact((long)a.intValue() + b.getIndeferidos()), Integer::sum);
        return List.of(RelatorioAnualEstatisticaDTO.of((String)"Pedidos", (Integer)pedidos), RelatorioAnualEstatisticaDTO.of((String)"Atendidos", (Integer)atendidos), RelatorioAnualEstatisticaDTO.of((String)"Cancelados", (Integer)cancelados), RelatorioAnualEstatisticaDTO.of((String)"Indeferidos", (Integer)indeferidos));
    }
}

