/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.params;

import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class ConsultaProcessoParams {
    private Long entidade;
    @Caption(value="Ano")
    private Long exercicio;
    @Caption(value="N\u00famero")
    private Long numero;
    @Caption(value="Senha")
    private String senha;
    @Caption(value="Tipo")
    private Long tipo;
    @Caption(value="Sigiloso")
    private Boolean sigiloso;
    @Caption(value="Desclassificado")
    private Boolean desclassificado;
    @Caption(value="Dt. Inicial Abertura")
    private String dataInicialAbertura;
    @Caption(value="Dt. Final Abertura")
    private String dataFinalAbertura;
    @Caption(value="Dt. Inicial Desclassifica\u00e7\u00e3o")
    private String dataInicialDesclassificacao;
    @Caption(value="Dt. Final Desclassifica\u00e7\u00e3o")
    private String dataFinalDesclassificacao;
    @Caption(value="Tipo do Grau de Sigilo")
    private String tipoGrauSigilo;
    private String exportType;

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addAno(params);
        this.addEntidade(params);
        return params;
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addAno(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("ano", (Object)this.exercicio, 2);
        }
    }

    public String getRSqlWhere() {
        ArrayList<String> filter = new ArrayList<String>();
        Optional.ofNullable(this.entidade).ifPresent(entidade -> filter.add(String.format("id.entidade.id==%s", entidade)));
        Optional.ofNullable(this.exercicio).ifPresent(exercicio -> filter.add(String.format("id.ano==%s", exercicio)));
        Optional.ofNullable(this.numero).ifPresent(numero -> filter.add(String.format("id.numero==%s", numero)));
        Optional.ofNullable(this.tipo).ifPresent(tipo -> filter.add(String.format("id.tipo.id==%s", tipo)));
        Optional.ofNullable(this.senha).ifPresent(senha -> filter.add(String.format("senha==\"%s\"", senha)));
        Optional.ofNullable(this.tipoGrauSigilo).ifPresent(tipoGrauSigilo -> filter.add(String.format("tipoGrauSigilo==\"%s\"", tipoGrauSigilo)));
        Optional.ofNullable(this.dataInicialAbertura).ifPresent(dataInicialAbertura -> filter.add(String.format("dataprocesso>=%s", dataInicialAbertura)));
        Optional.ofNullable(this.dataFinalAbertura).ifPresent(dataFinalAbertura -> filter.add(String.format("dataprocesso<=%s", dataFinalAbertura)));
        Optional.ofNullable(this.dataInicialDesclassificacao).ifPresent(dataInicialDesclassificacao -> filter.add(String.format("prazoDesclassificacao>=%s", dataInicialDesclassificacao)));
        Optional.ofNullable(this.dataFinalDesclassificacao).ifPresent(dataFinalDesclassificacao -> filter.add(String.format("prazoDesclassificacao<=%s", dataFinalDesclassificacao)));
        if (Boolean.TRUE.equals(this.sigiloso)) {
            filter.add(String.format("sigiloso==true and prazoDesclassificacao>=%s", LocalDate.now()));
        }
        if (Boolean.TRUE.equals(this.desclassificado)) {
            filter.add(String.format("sigiloso==true and prazoDesclassificacao<%s", LocalDate.now()));
        }
        return String.join((CharSequence)" and ", filter);
    }

    public String getRSqlWhereToOxy() {
        ArrayList<String> filter = new ArrayList<String>();
        Optional.ofNullable(this.entidade).ifPresent(entidade -> filter.add(String.format("id.entidade.id==%s", entidade)));
        Optional.ofNullable(this.exercicio).ifPresent(exercicio -> filter.add(String.format("id.ano==%s", exercicio)));
        Optional.ofNullable(this.numero).ifPresent(numero -> filter.add(String.format("id.numero==%s", numero)));
        Optional.ofNullable(this.tipo).ifPresent(tipo -> filter.add(String.format("id.tipo.id==%s", tipo)));
        Optional.ofNullable(this.senha).ifPresent(senha -> filter.add(String.format("senha==\"%s\"", senha)));
        Optional.ofNullable(this.tipoGrauSigilo).ifPresent(tipoGrauSigilo -> filter.add(String.format("grauSigilo.tipo==\"%s\"", tipoGrauSigilo)));
        Optional.ofNullable(this.dataInicialAbertura).ifPresent(dataInicialAbertura -> filter.add(String.format("dataProcesso>=%s", dataInicialAbertura)));
        Optional.ofNullable(this.dataFinalAbertura).ifPresent(dataFinalAbertura -> filter.add(String.format("dataProcesso<=%s", dataFinalAbertura)));
        Optional.ofNullable(this.dataInicialDesclassificacao).ifPresent(dataInicialDesclassificacao -> filter.add(String.format("prazoDesclassificacao>=%s", dataInicialDesclassificacao)));
        Optional.ofNullable(this.dataFinalDesclassificacao).ifPresent(dataFinalDesclassificacao -> filter.add(String.format("prazoDesclassificacao<=%s", dataFinalDesclassificacao)));
        if (Boolean.TRUE.equals(this.sigiloso)) {
            filter.add(String.format("sigiloso==true and prazoDesclassificacao>=%s", LocalDate.now()));
        }
        if (Boolean.TRUE.equals(this.desclassificado)) {
            filter.add(String.format("sigiloso==true and prazoDesclassificacao<%s", LocalDate.now()));
        }
        return String.join((CharSequence)" and ", filter);
    }

    public PesquisaProcessoParams toOxyParams() {
        PesquisaProcessoParams pesquisaProcessoParams = new PesquisaProcessoParams();
        pesquisaProcessoParams.setEntidade(this.getEntidade());
        pesquisaProcessoParams.setAno(this.getExercicio());
        pesquisaProcessoParams.setTipo(this.getTipo());
        pesquisaProcessoParams.setNumero(this.getNumero());
        pesquisaProcessoParams.setCpfSenha(this.getSenha());
        return pesquisaProcessoParams;
    }

    @Generated
    public String toString() {
        return "ConsultaProcessoParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", numero=" + this.getNumero() + ", senha=" + this.getSenha() + ", tipo=" + this.getTipo() + ", sigiloso=" + this.getSigiloso() + ", desclassificado=" + this.getDesclassificado() + ", dataInicialAbertura=" + this.getDataInicialAbertura() + ", dataFinalAbertura=" + this.getDataFinalAbertura() + ", dataInicialDesclassificacao=" + this.getDataInicialDesclassificacao() + ", dataFinalDesclassificacao=" + this.getDataFinalDesclassificacao() + ", tipoGrauSigilo=" + this.getTipoGrauSigilo() + ", exportType=" + this.getExportType() + ")";
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getNumero() {
        return this.numero;
    }

    @Generated
    public String getSenha() {
        return this.senha;
    }

    @Generated
    public Long getTipo() {
        return this.tipo;
    }

    @Generated
    public Boolean getSigiloso() {
        return this.sigiloso;
    }

    @Generated
    public Boolean getDesclassificado() {
        return this.desclassificado;
    }

    @Generated
    public String getDataInicialAbertura() {
        return this.dataInicialAbertura;
    }

    @Generated
    public String getDataFinalAbertura() {
        return this.dataFinalAbertura;
    }

    @Generated
    public String getDataInicialDesclassificacao() {
        return this.dataInicialDesclassificacao;
    }

    @Generated
    public String getDataFinalDesclassificacao() {
        return this.dataFinalDesclassificacao;
    }

    @Generated
    public String getTipoGrauSigilo() {
        return this.tipoGrauSigilo;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Generated
    public void setSenha(String senha) {
        this.senha = senha;
    }

    @Generated
    public void setTipo(Long tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setSigiloso(Boolean sigiloso) {
        this.sigiloso = sigiloso;
    }

    @Generated
    public void setDesclassificado(Boolean desclassificado) {
        this.desclassificado = desclassificado;
    }

    @Generated
    public void setDataInicialAbertura(String dataInicialAbertura) {
        this.dataInicialAbertura = dataInicialAbertura;
    }

    @Generated
    public void setDataFinalAbertura(String dataFinalAbertura) {
        this.dataFinalAbertura = dataFinalAbertura;
    }

    @Generated
    public void setDataInicialDesclassificacao(String dataInicialDesclassificacao) {
        this.dataInicialDesclassificacao = dataInicialDesclassificacao;
    }

    @Generated
    public void setDataFinalDesclassificacao(String dataFinalDesclassificacao) {
        this.dataFinalDesclassificacao = dataFinalDesclassificacao;
    }

    @Generated
    public void setTipoGrauSigilo(String tipoGrauSigilo) {
        this.tipoGrauSigilo = tipoGrauSigilo;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }
}

