/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.legislacaoportal.resource;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.diariooficial.client.feign.PublicationFeign;
import br.com.elotech.diariooficial.dto.PublicationDTO;
import java.util.UUID;
import lombok.Generated;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/legislacao/diarios-oficiais"})
public class DiarioOficialResource {
    private final PublicationFeign publicationFeign;

    @GetMapping(value={"/publicados"})
    public ResponseEntity<EloPage<PublicationDTO>> findAllDiariosPublicados(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.publicationFeign.findAllBy(search, pageable));
    }

    @GetMapping(value={"/url-download/{id}"})
    public ResponseEntity<String> getUrlDownload(@PathVariable(value="id") UUID id) {
        return ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).body((Object)this.publicationFeign.getUrlToDownload(id));
    }

    @Generated
    public DiarioOficialResource(PublicationFeign publicationFeign) {
        this.publicationFeign = publicationFeign;
    }
}

