/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.contabportal.domain.QTotalAcesso;
import br.com.elotech.portaltransparencia.contabportal.domain.TotalAcesso;
import br.com.elotech.portaltransparencia.contabportal.repository.TotalAcessoRepository;
import br.com.elotech.portaltransparencia.contabportal.service.TotalAcessoLockService;
import com.querydsl.core.types.Predicate;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TotalAcessoService {
    private final TotalAcessoRepository totalAcessoRepository;
    private final TotalAcessoLockService totalAcessoLockService;

    @Transactional
    public TotalAcesso getTotalAcesso() {
        TotalAcesso totalAcesso;
        this.totalAcessoLockService.lockTable();
        Optional totalAcessoOptional = this.totalAcessoRepository.findOne((Predicate)QTotalAcesso.totalAcesso.data.eq((Object)LocalDate.now()));
        if (totalAcessoOptional.isPresent()) {
            totalAcesso = (TotalAcesso)totalAcessoOptional.get();
        } else {
            totalAcesso = new TotalAcesso();
            totalAcesso.setId(this.totalAcessoRepository.getNextId());
        }
        totalAcesso.incrementa();
        this.totalAcessoRepository.save((Object)totalAcesso);
        return TotalAcesso.builder().totalAcessos(this.totalAcessoRepository.getTotalAcessos()).build();
    }

    @Transactional
    public TotalAcesso calculateTotalAcessoDiarioOficial() {
        this.totalAcessoLockService.lockTable();
        TotalAcesso totalAcesso = this.totalAcessoRepository.findByData(LocalDate.now()).orElseGet(() -> {
            TotalAcesso newTotalAcesso = new TotalAcesso();
            newTotalAcesso.setId(this.totalAcessoRepository.getNextId());
            return newTotalAcesso;
        });
        totalAcesso.incrementaDiarioOficial();
        return (TotalAcesso)this.totalAcessoRepository.save((Object)totalAcesso);
    }

    @Generated
    public TotalAcessoService(TotalAcessoRepository totalAcessoRepository, TotalAcessoLockService totalAcessoLockService) {
        this.totalAcessoRepository = totalAcessoRepository;
        this.totalAcessoLockService = totalAcessoLockService;
    }
}

