/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.contabilidade.client.ExercicioFeignClient;
import br.com.elotech.portaltransparencia.contabportal.domain.ConfiguracaoInterface;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.Exercicio;
import br.com.elotech.portaltransparencia.contabportal.domain.ExercicioPK;
import br.com.elotech.portaltransparencia.contabportal.service.ConfiguracaoService;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.contabportal.service.ExercicioService;
import br.com.elotech.portaltransparencia.utils.ExercicioParamsUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class ExercicioOxyService
implements ExercicioService {
    private final EntidadeContabilidadeService entidadeContabilidadeService;
    private final ExercicioFeignClient exercicioFeignClient;
    private final ExercicioParamsUtils exercicioUtils;
    private final ConfiguracaoService configuracaoService;

    public List<Exercicio> getExercicios(Long idEntidade) {
        ConfiguracaoInterface configuracao = this.configuracaoService.getConfiguracao();
        Long anoInicial = this.getAnoDiferenteZero(configuracao.getAnoInicial(), this.exercicioUtils.getAnoInicial(idEntidade));
        Long anoFinal = this.getAnoDiferenteZero(configuracao.getAnoFinal(), this.exercicioUtils.getAnoFinal(idEntidade));
        String search = "entidade.id==" + idEntidade + " and " + String.format("exercicio=ge=%d", anoInicial) + " and " + String.format("exercicio=le=%d", anoFinal);
        return this.exercicioFeignClient.findAll(search, (Pageable)PageRequest.of((int)0, (int)9999, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"exercicio"}))).getContent().stream().map(Exercicio::fromExercicioContabilidade).collect(Collectors.toList());
    }

    public Optional<Exercicio> findExercicioPadrao() {
        Entidade entidadePrincipal;
        List exercicios;
        Optional entidadePrincipalOptional = this.entidadeContabilidadeService.getEntidadePrincipal();
        if (entidadePrincipalOptional.isPresent() && !(exercicios = this.getExercicios((entidadePrincipal = (Entidade)entidadePrincipalOptional.get()).getId())).isEmpty()) {
            return Optional.ofNullable((Exercicio)exercicios.get(0));
        }
        return Optional.empty();
    }

    public Exercicio findOne(ExercicioPK pk) {
        return null;
    }

    public Long findModeloDespesa(Long entidade, Long exercicio) {
        return null;
    }

    private Long getAnoDiferenteZero(Long ano, Long anoEntidade) {
        if (Objects.isNull(ano) || ano.equals(0L)) {
            return anoEntidade;
        }
        return ano;
    }

    public List<Exercicio> getExerciciosByAno(Long idEntidade, Long ano) {
        return this.getExercicios(idEntidade);
    }

    @Generated
    public ExercicioOxyService(EntidadeContabilidadeService entidadeContabilidadeService, ExercicioFeignClient exercicioFeignClient, ExercicioParamsUtils exercicioUtils, ConfiguracaoService configuracaoService) {
        this.entidadeContabilidadeService = entidadeContabilidadeService;
        this.exercicioFeignClient = exercicioFeignClient;
        this.exercicioUtils = exercicioUtils;
        this.configuracaoService = configuracaoService;
    }
}

