/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.caelum.stella.type.Estado;
import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.comprasportal.service.NadItemPercentualService;
import br.com.elotech.portaltransparencia.contabportal.domain.Empenho;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.FichaEmpenho;
import br.com.elotech.portaltransparencia.contabportal.domain.NivelModeloDespesa;
import br.com.elotech.portaltransparencia.contabportal.domain.Parametro;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ComprasDiretaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoAnexosDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoAnulacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDocumentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoEmLiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoItensDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoLinksDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoLiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoMovimentacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoPagamentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoRestosAPagarDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoRetencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhosListaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioEmpenhoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.enums.ParametroEnum;
import br.com.elotech.portaltransparencia.contabportal.mapper.ComprasDiretaToDTO;
import br.com.elotech.portaltransparencia.contabportal.mapper.EmpenhoToDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EmpenhoRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.NivelModeloDespesaRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.ParametroRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.PatrimonioMovimentoEmpenhoRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.impl.ParametroRepositoryImpl;
import br.com.elotech.portaltransparencia.contabportal.service.EmpenhoService;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.contabportal.service.ExercicioService;
import br.com.elotech.portaltransparencia.report.EmpenhoReport;
import br.com.elotech.portaltransparencia.report.ReportUtils;
import br.com.elotech.portaltransparencia.rsql.CustomRsqlUtils;
import br.com.elotech.portaltransparencia.web.rest.params.EmpenhoParams;
import br.com.elotech.portaltransparencia.web.rest.params.ProgramaticaParams;
import brave.internal.Nullable;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public class EmpenhoSustentacaoService
implements EmpenhoService {
    private static final String EXERCICIO = "exercicio";
    private static final String ENTIDADE = "entidade";
    private static final String EMPENHO = "empenho";
    private static final String ID = "id";
    private static final String SIM = "S";
    private static final String PROGRAMATICA = "programatica";
    private static final String TIPO_P = "P";
    private static final String TIPO_C = "C";
    private static final int NIVEL_1 = 1;
    private static final int NIVEL_2 = 2;
    private static final int NIVEL_3 = 3;
    private static final int NIVEL_4 = 4;
    private static final int NIVEL_5 = 5;
    private static final int NIVEL_6 = 6;
    private static final int NIVEL_7 = 7;
    private static final BigDecimal EPSILON = new BigDecimal("0.001");
    private static final Long MODELODESPESA = 3L;
    private static final Integer POSICAO_NATUREZA = 23;
    private static final Integer TAMANHO_NATUREZA = 2;
    private static final Integer TAMANHO_ELEMENTO_RO = 6;
    private static final String ISCOVID = "mpCovid19";
    private static final String TIPO_EMPENHO = "tipo";
    private final EmpenhoRepository empenhoRepository;
    private final NivelModeloDespesaRepository nivelModeloDespesaRepository;
    private final PatrimonioMovimentoEmpenhoRepository patrimonioMovRepository;
    private final ArquivoService arquivoService;
    private final EntidadeContabilidadeService entidadeService;
    private final EntityManager em;
    private final NadItemPercentualService nadItemPercentualService;
    private final ParametroRepository parametroRepository;
    private final ExercicioService exercicioService;
    private final DBConfigProperties dbConfigProperties;
    private final ParametroRepositoryImpl parametroContabilRepository;

    @Autowired
    public EmpenhoSustentacaoService(EmpenhoRepository empenhoRepository, NivelModeloDespesaRepository nivelModeloDespesaRepository, PatrimonioMovimentoEmpenhoRepository patrimonioMovRepository, ArquivoService arquivoService, EntidadeContabilidadeService entidadeService, NadItemPercentualService nadItemPercentualService, ParametroRepository parametroRepository, ExercicioService exercicioService, EntityManager em, DBConfigProperties dbConfigProperties, ParametroRepositoryImpl parametroContabilRepository) {
        this.empenhoRepository = empenhoRepository;
        this.nivelModeloDespesaRepository = nivelModeloDespesaRepository;
        this.patrimonioMovRepository = patrimonioMovRepository;
        this.arquivoService = arquivoService;
        this.entidadeService = entidadeService;
        this.em = em;
        this.nadItemPercentualService = nadItemPercentualService;
        this.parametroRepository = parametroRepository;
        this.exercicioService = exercicioService;
        this.dbConfigProperties = dbConfigProperties;
        this.parametroContabilRepository = parametroContabilRepository;
    }

    public Page<EmpenhosListaDTO> getEmpenhosSearch(Pageable pageable, EmpenhoParams params) {
        PageRequest page = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageable.getSortOr(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"data", "id.empenho"})));
        Specification specification = this.getSpecificationEmpenho(params);
        return this.empenhoRepository.findAll(specification, (Pageable)page).map(arg_0 -> ((EmpenhoToDTO)new EmpenhoToDTO()).apply(arg_0));
    }

    private Specification<Empenho> getSpecificationEmpenho(EmpenhoParams params) {
        ProgramaticaParams programatica;
        Specification specification = Specification.where((Specification)CustomRsqlUtils.createSpecFrom((EntityManager)this.em, (String)params.getSearch(), (String)this.dbConfigProperties.getContabilidade().getSchema()));
        specification = specification.and(this.contabilizadoSpecification());
        if (Objects.nonNull(params.getEntidade()) && params.getEntidade() > 0L) {
            specification = specification.and(this.entidadeSpecification(params));
        }
        if (Objects.nonNull(params.getExercicio())) {
            specification = specification.and(this.exercicioSpecification(params));
        }
        if (Objects.nonNull(params.getAPagar()) && params.getAPagar().booleanValue()) {
            specification = specification.and(this.empenhosAPagarSpecification());
        }
        if (Objects.nonNull(params.getPassagens()) && params.getPassagens().booleanValue()) {
            specification = specification.and(this.passagensOrConsumoOrPermanenteSpecification("33").and(this.desdobramentoSpecification("", Boolean.valueOf(true), Boolean.valueOf(true))).or(this.passagensOrConsumoOrPermanenteSpecification("30").and(this.desdobramentoSpecification("", Boolean.valueOf(true), Boolean.valueOf(false)))));
        }
        if (Objects.nonNull(params.getConsumo()) && params.getConsumo().booleanValue()) {
            specification = specification.and(this.passagensOrConsumoOrPermanenteSpecification("30").or(this.passagensOrConsumoOrPermanenteSpecification("32")));
        }
        if (Objects.nonNull(params.getPermanente()) && params.getPermanente().booleanValue()) {
            specification = specification.and(this.passagensOrConsumoOrPermanenteSpecification("52"));
        }
        if (Objects.nonNull(params.getRestituicoesCombustiveis()) && params.getRestituicoesCombustiveis().booleanValue()) {
            specification = specification.and(this.filtrarRestituicoesCombustiveis(params).and(this.desdobramentoSpecification("01", Boolean.valueOf(false), Boolean.valueOf(false))));
        }
        if (Objects.nonNull(params.getAuxilioFinanceiro()) && params.getAuxilioFinanceiro().booleanValue()) {
            specification = specification.and(this.filtrarAuxilioFinanceiro(params).and(this.isCovidSpecification()));
        }
        if (Objects.nonNull(params.getComprasDireta()) && params.getComprasDireta().booleanValue()) {
            if (Estado.RO.name().equalsIgnoreCase(this.entidadeService.getUf(this.entidadeService.getEntidadeSelecionada(params.getEntidade()).getId()))) {
                specification = specification.and(this.dispensaInexigibilidadeSpecification());
                specification = specification.and(this.filtrarElementosAdquireBens(this.entidadeService.getEntidadeSelecionada(params.getEntidade()).getId(), params.getExercicio()));
            } else {
                specification = specification.and(this.dispensaLicitacaoSpecification());
                specification = specification.and(this.dispensaLicitacaoNaturezaSpecification());
            }
        }
        if (Objects.nonNull(params.getCodigoNivelDespesa())) {
            specification = specification.and(this.codigoNivelDespesaSpecification(params));
        }
        if (Objects.nonNull(params.getTipoBem()) && Objects.nonNull(params.getChapaBem())) {
            specification = specification.and(this.bemPatrimonialSpecification(params));
        }
        if (Objects.nonNull(programatica = params.getProgramatica()) && Objects.nonNull(programatica.getOrgao())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_P, Integer.valueOf(1), programatica.getOrgao()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getUnidade())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_C, Integer.valueOf(2), programatica.getUnidade()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getFuncao())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_P, Integer.valueOf(3), programatica.getFuncao()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getSubFuncao())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_P, Integer.valueOf(4), programatica.getSubFuncao()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getPrograma())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_P, Integer.valueOf(5), programatica.getPrograma()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getProjeto())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_P, Integer.valueOf(6), programatica.getProjeto()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getElemento())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_C, Integer.valueOf(7), programatica.getElemento()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getDesdobramento())) {
            specification = specification.and(this.desdobramentoSpecification(programatica.getDesdobramento(), Boolean.valueOf(false), Boolean.valueOf(false)));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getSubDesdobramento())) {
            specification = specification.and(this.subDesdobramentoSpecification(programatica.getSubDesdobramento()));
        }
        if (Objects.nonNull(params.getFonteRecurso())) {
            specification = specification.and(this.fonteRecursoSpecification(Long.valueOf(params.getFonteRecurso())));
        }
        if (Objects.nonNull(params.getEsfera())) {
            specification = specification.and(this.esferaSpecification(params.getEsfera()));
        }
        if (Objects.nonNull(params.getIsCovid())) {
            specification = specification.and(this.isCovidSpecification());
        }
        if (Objects.nonNull(params.getIsFundeb())) {
            specification = specification.and(this.isFundebSpecification(params));
        }
        if (Objects.nonNull(params.getNome())) {
            specification = specification.and(this.nomeFornecedorSpecification(params));
        }
        return specification;
    }

    private Specification<Empenho> nomeFornecedorSpecification(EmpenhoParams params) {
        return (Specification & Serializable)(root, query, cb) -> {
            Join empenhoFornecedor = root.join("fornecedor");
            Expression otherwise = cb.selectCase().when((Expression)cb.lessThan((Expression)root.get("data"), (Expression)empenhoFornecedor.get("inicioVigenciaNome")), (Expression)empenhoFornecedor.get("nomeAntigo")).otherwise((Expression)empenhoFornecedor.get("nome")).as(String.class);
            return cb.like(cb.upper(otherwise), params.getNome());
        };
    }

    private Specification<Empenho> isCovidSpecification() {
        return (Specification & Serializable)(root, query, cb) -> cb.or((Expression)cb.equal((Expression)root.get(ISCOVID), (Object)SIM), (Expression)root.get(TIPO_EMPENHO).in(Arrays.asList("4", "5", "6")));
    }

    private Specification<Empenho> isFundebSpecification(EmpenhoParams params) {
        String campo;
        Long entidade = params.getEntidade();
        if (Objects.isNull(entidade)) {
            entidade = ((Entidade)this.entidadeService.getEntidadePrincipal().get()).getId();
        }
        Parametro paramNivel = this.parametroContabilRepository.findByEntidadeExercicioModuloAndCodigo(entidade, params.getExercicio(), ModuloEnum.MODULO_SISCOP.getValue(), ParametroEnum.PARAM_NIVEL_FONTERECURSO_FUNDEB.getCodigo());
        switch (paramNivel.getValor()) {
            case "1": {
                campo = ID;
                break;
            }
            case "2": {
                campo = "codigofontepadraotce";
                break;
            }
            case "3": {
                campo = "codigoorigem";
                break;
            }
            case "4": {
                campo = "codigoaplicacao";
                break;
            }
            case "5": {
                campo = "codigodesdobramento";
                break;
            }
            case "6": {
                campo = "identificadoruso";
                break;
            }
            case "7": {
                campo = "codigogrupo";
                break;
            }
            case "8": {
                campo = "codigodestinacao";
                break;
            }
            case "9": {
                campo = "codigodetalhamento";
                break;
            }
            default: {
                campo = ID;
            }
        }
        Parametro paramValor = this.parametroContabilRepository.findByEntidadeExercicioModuloAndCodigo(entidade, params.getExercicio(), ModuloEnum.MODULO_SISCOP.getValue(), ParametroEnum.PARAM_VALOR_FONTERECURSO_FUNDEB.getCodigo());
        return (Specification & Serializable)(root, query, cb) -> {
            Path fonteRecursoPath = root.get("fonteRecurso").get("codigofontepadrao").get(campo);
            String[] valoresParametro = new String[10];
            valoresParametro = paramValor.getValor().split(";");
            return fonteRecursoPath.in((Object[])valoresParametro);
        };
    }

    public EmpenhosListaDTO getEmpenhosTotal(EmpenhoParams params) {
        Specification spec = this.getSpecificationEmpenho(params);
        return this.empenhoRepository.geTotaisEmpenhos(params, spec);
    }

    private Specification<Empenho> contabilizadoSpecification() {
        return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("contabilizado"), (Object)SIM);
    }

    private Specification<Empenho> entidadeSpecification(EmpenhoParams params) {
        return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(ID).get(ENTIDADE), (Object)params.getEntidade());
    }

    private Specification<Empenho> empenhosAPagarSpecification() {
        return (Specification & Serializable)(root, query, cb) -> {
            Subquery subquery = query.subquery(BigDecimal.class);
            Root rootFicha = subquery.from(FichaEmpenho.class);
            Expression valor = cb.sum((Expression)rootFicha.get("valor"));
            Expression valorAnulacoes = cb.sum((Expression)rootFicha.get("valorAnulacoes"));
            Expression valorEstAnulacoes = cb.sum((Expression)rootFicha.get("valorEstAnulacoes"));
            Expression valorPago = cb.sum((Expression)rootFicha.get("valorPagamento"));
            Expression valorEstPagamento = cb.sum((Expression)rootFicha.get("valorEstPagamento"));
            Expression valorRetencoes = cb.sum((Expression)rootFicha.get("valorRetencoes"));
            Expression totalEmpenhado = cb.diff(valor, cb.diff(valorAnulacoes, valorEstAnulacoes));
            Expression totalPago = cb.sum(cb.diff(valorPago, valorEstPagamento), valorRetencoes);
            Expression saldoAPagar = cb.diff(totalEmpenhado, totalPago);
            subquery.select(saldoAPagar);
            subquery.where(new Predicate[]{cb.equal((Expression)rootFicha.get(ID).get(EMPENHO).get(ID).get("unidadeOrcamentaria"), (Expression)root.get(ID).get("unidadeOrcamentaria")), cb.equal((Expression)rootFicha.get(ID).get(EMPENHO).get(ID).get(ENTIDADE), (Expression)root.get(ID).get(ENTIDADE)), cb.equal((Expression)rootFicha.get(ID).get(EMPENHO).get(ID).get(EMPENHO), (Expression)root.get(ID).get(EMPENHO)), cb.equal((Expression)rootFicha.get(ID).get(EMPENHO).get(ID).get(EXERCICIO), (Expression)root.get(ID).get(EXERCICIO))});
            return cb.gt(subquery.as(BigDecimal.class), (Number)EPSILON);
        };
    }

    private Specification<Empenho> passagensOrConsumoOrPermanenteSpecification(String pNatureza) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path programatica = root.get(PROGRAMATICA);
            Expression natureza = cb.substring((Expression)programatica, POSICAO_NATUREZA.intValue(), TAMANHO_NATUREZA.intValue());
            return cb.equal(natureza, (Object)pNatureza);
        };
    }

    private Specification<Empenho> dispensaInexigibilidadeSpecification() {
        return (Specification & Serializable)(root, query, cb) -> {
            Path tipoLicitacao = root.get("tipoLicitacao").get(ID);
            return tipoLicitacao.in(new Object[]{"01", "06", "09"});
        };
    }

    private Specification<Empenho> dispensaLicitacaoSpecification() {
        return (Specification & Serializable)(root, query, cb) -> {
            Path tipoLicitacao = root.get("tipoLicitacao").get(ID);
            return cb.equal((Expression)tipoLicitacao, (Object)"00");
        };
    }

    private Specification<Empenho> dispensaLicitacaoNaturezaSpecification() {
        return (Specification & Serializable)(root, query, cb) -> {
            Path programatica = root.get(PROGRAMATICA);
            Expression natureza = cb.substring((Expression)programatica, POSICAO_NATUREZA.intValue(), TAMANHO_NATUREZA.intValue());
            return natureza.in(new Object[]{"30", "32", "33", "35", "36", "37", "39", "51", "52", "61", "62"});
        };
    }

    private Specification<Empenho> filtrarElementosAdquireBens(Long entidade, Long exercicio) {
        return (Specification & Serializable)(root, query, cb) -> {
            Long modeloDespesa = this.exercicioService.findModeloDespesa(entidade, exercicio);
            NivelModeloDespesa nmd = this.nivelModeloDespesaRepository.findbyOrdemModelo(modeloDespesa, TIPO_C, Integer.valueOf(7));
            Integer posicao = nmd.getPosicao().intValue();
            Path programatica = root.get(PROGRAMATICA);
            Expression natureza = cb.substring((Expression)programatica, posicao.intValue(), TAMANHO_ELEMENTO_RO.intValue());
            return natureza.in(new Object[]{"339030", "339032", "449052"});
        };
    }

    private Specification<Empenho> filtrarRestituicoesCombustiveis(EmpenhoParams params) {
        return (Specification & Serializable)(root, query, cb) -> {
            Long entidade = params.getEntidade();
            if (Objects.isNull(entidade)) {
                entidade = ((Entidade)this.entidadeService.getEntidadePrincipal().get()).getId();
            }
            Long modeloDespesa = this.exercicioService.findModeloDespesa(entidade, params.getExercicio());
            NivelModeloDespesa nmd = this.nivelModeloDespesaRepository.findbyOrdemModelo(modeloDespesa, TIPO_C, Integer.valueOf(7));
            Integer posicao = nmd.getPosicao().intValue();
            Path programatica = root.get(PROGRAMATICA);
            Expression natureza = cb.substring((Expression)programatica, posicao.intValue(), TAMANHO_ELEMENTO_RO.intValue());
            return natureza.in(new Object[]{"339093"});
        };
    }

    private Specification<Empenho> filtrarAuxilioFinanceiro(EmpenhoParams params) {
        return (Specification & Serializable)(root, query, cb) -> {
            Long entidade = params.getEntidade();
            if (Objects.isNull(entidade)) {
                entidade = ((Entidade)this.entidadeService.getEntidadePrincipal().get()).getId();
            }
            Long modeloDespesa = this.exercicioService.findModeloDespesa(entidade, params.getExercicio());
            NivelModeloDespesa nmd = this.nivelModeloDespesaRepository.findbyOrdemModelo(modeloDespesa, TIPO_C, Integer.valueOf(7));
            Integer posicao = nmd.getPosicao().intValue();
            Path programatica = root.get(PROGRAMATICA);
            Expression natureza = cb.substring((Expression)programatica, posicao.intValue(), TAMANHO_ELEMENTO_RO.intValue());
            return natureza.in(new Object[]{"339048"});
        };
    }

    private Specification<Empenho> exercicioSpecification(EmpenhoParams params) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path exercicioPath = root.get(ID).get(EXERCICIO);
            if (Objects.nonNull(params.getAPagar()) && params.getAPagar().booleanValue()) {
                return cb.le((Expression)exercicioPath, (Number)params.getExercicio());
            }
            return cb.equal((Expression)exercicioPath, (Object)params.getExercicio());
        };
    }

    private Specification<Empenho> codigoNivelDespesaSpecification(EmpenhoParams params) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path programatica = root.get(PROGRAMATICA);
            NivelModeloDespesa nivelModeloDespesa = this.nivelModeloDespesaRepository.findbyNivelModelo(MODELODESPESA, params.getTipoNivelDespesa(), params.getNivelLei());
            Expression nivelDespesa = cb.substring((Expression)programatica, nivelModeloDespesa.getPosicao().intValue(), nivelModeloDespesa.getTamanho().intValue());
            return cb.equal(nivelDespesa, (Object)params.getCodigoNivelDespesa());
        };
    }

    private Specification<Empenho> bemPatrimonialSpecification(EmpenhoParams params) {
        return (Specification & Serializable)(root, query, cb) -> {
            List listEmpenho = this.patrimonioMovRepository.getPatrimonioEmpenho(params);
            ArrayList predicates = Lists.newArrayList();
            Path exercicio = root.get(ID).get(EXERCICIO);
            Path empenho = root.get(ID).get(EMPENHO);
            for (PatrimonioEmpenhoDTO emp : listEmpenho) {
                Predicate exp = cb.equal((Expression)exercicio, (Object)emp.getExercicio());
                Predicate exp2 = cb.equal((Expression)empenho, (Object)emp.getEmpenho());
                predicates.add(cb.and((Expression)exp, (Expression)exp2));
            }
            return cb.or(predicates.toArray(new Predicate[predicates.size()]));
        };
    }

    private Specification<Empenho> programaticaPorNivelSpecification(String tipo, Integer nivel, String valor) {
        return (Specification & Serializable)(root, query, cb) -> {
            NivelModeloDespesa nmd = this.nivelModeloDespesaRepository.findbyOrdemModelo(MODELODESPESA, tipo, nivel);
            Integer posicao = nmd.getPosicao().intValue();
            Integer tamanho = nmd.getTamanho().intValue();
            Expression natureza = cb.substring((Expression)root.get(PROGRAMATICA), posicao.intValue(), tamanho.intValue());
            if (nivel == 7) {
                return cb.like(natureza, valor);
            }
            return cb.equal(natureza, (Object)valor);
        };
    }

    private Specification<Empenho> desdobramentoSpecification(String desdobramento, @Nullable Boolean passagem, @Nullable Boolean isNatureza33) {
        if (passagem.booleanValue()) {
            return (Specification & Serializable)(root, query, cb) -> {
                Path desdobramentoin = root.get("desdobramento");
                if (isNatureza33.booleanValue()) {
                    return desdobramentoin.in(new Object[]{"01", "02"});
                }
                return desdobramentoin.in(new Object[]{"49"});
            };
        }
        return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("desdobramento"), (Object)desdobramento);
    }

    private Specification<Empenho> subDesdobramentoSpecification(String subDesdobramento) {
        return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("subDesdobramento"), (Object)subDesdobramento);
    }

    private Specification<Empenho> fonteRecursoSpecification(Long fonteRecurso) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path fonteRecursoPath = root.get("fonteRecurso").get(ID);
            return cb.equal((Expression)fonteRecursoPath, (Object)fonteRecurso);
        };
    }

    private Specification<Empenho> esferaSpecification(String esfera) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path esferaPath = root.get("despesa").get("esfera");
            return cb.equal((Expression)esferaPath, (Object)esfera);
        };
    }

    public EmpenhoDTO getEmpenhoDetalhe(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalhe(params);
    }

    public List<EmpenhoItensDTO> getEmpenhoDetalheItens(EmpenhoParams params) {
        List itens = this.empenhoRepository.getEmpenhoDetalheItens(params);
        itens.forEach(item -> item.setItensPerc(this.nadItemPercentualService.getEmpenhoDetalheItensPerc(item)));
        return itens;
    }

    public List<EmpenhoAnulacaoDTO> getEmpenhoDetalheAnulacao(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheAnulacao(params);
    }

    public List<EmpenhoLiquidacaoDTO> getEmpenhoDetalheLiquidacao(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheLiquidacao(params);
    }

    public List<EmpenhoPagamentoDTO> getEmpenhoDetalhePagamento(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalhePagamento(params);
    }

    public List<EmpenhoRetencaoDTO> getEmpenhoDetalheRetencao(EmpenhoParams params) {
        Parametro contabilaRetencao = this.parametroRepository.findByEntidadeExercicioModuloAndCodigo(params.getEntidade(), params.getExercicio(), ModuloEnum.MODULO_SISCOP.getValue(), ParametroEnum.CONTABILIZA_RETENCAO.getCodigo());
        if (contabilaRetencao.getValor().equals(TIPO_P)) {
            return this.empenhoRepository.getEmpenhoDetalheRetencaoOrdemPagamento(params);
        }
        return this.empenhoRepository.getEmpenhoDetalheRetencao(params);
    }

    public List<EmpenhoDocumentoDTO> getEmpenhoDetalheDocumentos(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheDocumentos(params);
    }

    public Page<EmpenhoMovimentacaoDTO> getEmpenhoDetalheMovimentacao(Pageable pageable, EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheMovimentacao(pageable, params);
    }

    public List<EmpenhoAnexosDTO> getEmpenhoDetalheAnexos(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheAnexos(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<EmpenhoLinksDTO> getEmpenhoDetalheLinks(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheLinks(params);
    }

    public Page<ComprasDiretaDTO> getComprasDiretaItensEmpenho(Pageable pageable, EmpenhoParams params) {
        Specification specification = this.getSpecificationEmpenho(params);
        PageRequest pageRequest = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id.exercicio", "id.empenho"});
        Page page = this.empenhoRepository.findAll(specification, (Pageable)pageRequest);
        List itemDTO = page.getContent().stream().flatMap(e -> e.getItems().stream().map(arg_0 -> ((ComprasDiretaToDTO)new ComprasDiretaToDTO()).apply(arg_0))).collect(Collectors.toList());
        return new PageImpl(itemDTO, pageable, page.getTotalElements());
    }

    public EmpenhoItensDTO getEmpenhoDetalheItem(EmpenhoParams params) {
        List itens = this.empenhoRepository.getEmpenhoDetalheItens(params);
        EmpenhoItensDTO item = itens.stream().findFirst().orElse(new EmpenhoItensDTO());
        item.setItensPerc(this.nadItemPercentualService.getEmpenhoDetalheItensPerc(item));
        return item;
    }

    public List<EmpenhoEmLiquidacaoDTO> getEmpenhoDetalheEmLiquidacao(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheEmLiquidacao(params);
    }

    public byte[] gerarRelatorioPdf(EmpenhoParams params) {
        return ReportUtils.exportToPdfByJasperPrint((JasperPrint)this.gerarRelatorio(params));
    }

    private JasperPrint gerarRelatorio(EmpenhoParams params) {
        EmpenhoDTO dados = this.getDadosPreview(params);
        JasperReport jasperReport = ReportUtils.getJasperReportByLocation((String)"classpath:reports/nota_empenho.jasper");
        Entidade entidadeS = this.entidadeService.findOne(params.getEntidade());
        if (SIM.equalsIgnoreCase(this.entidadeService.isHabilitadoAssinaturaPersonalizadaFundo(params.getEntidade(), params.getExercicio(), dados.getOrgao(), dados.getUnidade()))) {
            entidadeS.setNome(this.entidadeService.getNomeFundo(params.getEntidade(), params.getExercicio(), dados.getOrgao(), dados.getUnidade()));
            entidadeS.setCnpj(this.entidadeService.getCNPJFundo(params.getEntidade(), params.getExercicio(), dados.getOrgao(), dados.getUnidade()));
        }
        Map parameters = EmpenhoReport.getParameters((Entidade)entidadeS);
        return JasperFillManager.fillReport((JasperReport)jasperReport, (Map)parameters, (JRDataSource)new JRBeanCollectionDataSource(Arrays.asList(dados)));
    }

    public EmpenhoDTO getDadosPreview(EmpenhoParams params) {
        return this.empenhoRepository.getDadosPreview(params);
    }

    public Page<EmpenhoRestosAPagarDTO> getEmpenhoRestosAPagar(Pageable pageable, EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoRestosAPagar(params, pageable);
    }

    public List<EmpenhoMovimentacaoDTO> getEmpenhoDetalheMovimentacao(EmpenhoParams params) {
        return null;
    }
}

