/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.contabilidade.client.EmpenhoFeignClient;
import br.com.elotech.contabilidade.client.dto.EmpenhoTotalDTO;
import br.com.elotech.contabilidade.client.params.EmpenhoParamsDTO;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ComprasDiretaFornecedorDTO;
import br.com.elotech.portaltransparencia.contabportal.service.ComprasDiretaService;
import br.com.elotech.portaltransparencia.contabportal.utils.EmpenhoOxyUtils;
import br.com.elotech.portaltransparencia.web.rest.params.ComprasDiretaParams;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ComprasDiretaOxyService
implements ComprasDiretaService {
    private final EmpenhoFeignClient empenhoFeignClient;

    public Page<ComprasDiretaFornecedorDTO> getFornecedores(Pageable pageable, ComprasDiretaParams params) {
        EloPage fornecedores = this.empenhoFeignClient.findAllFornecedoresByRsqlWithMovimento(this.buildSearch(params), EmpenhoOxyUtils.translateSortToOxy((Pageable)pageable), EmpenhoParamsDTO.builder().onlyComprasDireta(Boolean.TRUE).build());
        return new PageImpl(fornecedores.getContent().stream().map(ComprasDiretaFornecedorDTO::new).collect(Collectors.toList()), pageable, fornecedores.getTotalElements());
    }

    public ComprasDiretaFornecedorDTO getFornecedoresTotais(ComprasDiretaParams params) {
        EmpenhoTotalDTO empenhoTotalDTO = this.empenhoFeignClient.getTotal(this.buildSearch(params), EmpenhoParamsDTO.builder().onlyComprasDireta(Boolean.TRUE).build());
        return new ComprasDiretaFornecedorDTO(empenhoTotalDTO);
    }

    private String buildSearch(ComprasDiretaParams params) {
        StringBuilder rsql = new StringBuilder();
        EmpenhoOxyUtils.applyFilter((StringBuilder)rsql, (String)params.getNome(), (String)"credor.nome=='*%s*'");
        if (rsql.length() > 0) {
            EmpenhoOxyUtils.applyFilter((StringBuilder)rsql, (String)params.getCnpjCpf(), (String)";credor.cnpjCpf=='*%s*'");
        } else {
            EmpenhoOxyUtils.applyFilter((StringBuilder)rsql, (String)params.getCnpjCpf(), (String)"credor.cnpjCpf=='*%s*'");
        }
        return rsql.toString();
    }

    @Generated
    public ComprasDiretaOxyService(EmpenhoFeignClient empenhoFeignClient) {
        this.empenhoFeignClient = empenhoFeignClient;
    }
}

