/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource.params;

import br.com.elotech.portaltransparencia.contabportal.resource.params.RenunciaReceitaParams;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class RenunciaReceitaParams {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private Long id;
    private Long entidade;
    private Long exercicio;
    private String setorBeneficiario;
    private String tributo;
    private String compensacao;
    private String descTipoTributo;
    private String descTipoModalidade;
    private String exportType;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataInicio;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataFim;

    public Optional<Long> getId() {
        return Optional.ofNullable(this.id);
    }

    public Optional<Long> getEntidade() {
        return Optional.ofNullable(this.entidade);
    }

    public Optional<Long> getExercicio() {
        return Optional.ofNullable(this.exercicio);
    }

    public Optional<String> getSetorBeneficiario() {
        return Optional.ofNullable(this.setorBeneficiario);
    }

    public Optional<String> getCompensacao() {
        return Optional.ofNullable(this.compensacao);
    }

    public Optional<String> getTributo() {
        return Optional.ofNullable(this.tributo);
    }

    public Optional<String> getDescTipoTributo() {
        return Optional.ofNullable(this.descTipoTributo);
    }

    public Optional<String> getDescTipoModalidade() {
        return Optional.ofNullable(this.descTipoModalidade);
    }

    public LocalDate getDataInicio() {
        return this.dataInicio;
    }

    public LocalDate getDataFim() {
        return this.dataFim;
    }

    public Long getTipoTributo() {
        switch ((String)this.getDescTipoTributo().get()) {
            case "IPTU": {
                return 1L;
            }
            case "ITBI": {
                return 2L;
            }
            case "ISS": {
                return 3L;
            }
            case "CONTRIBUI\u00c7\u00c3O DE MELHORIA": {
                return 4L;
            }
            case "TAXAS": {
                return 5L;
            }
            case "OUTROS TRIBUTOS": {
                return 6L;
            }
            case "COSIP": {
                return 7L;
            }
            case "IMPUGNA\u00c7\u00d5ES/IMPOSI\u00c7\u00d5ES": {
                return 8L;
            }
        }
        return 0L;
    }

    public Long getTipoModalidade() {
        switch ((String)this.getDescTipoModalidade().get()) {
            case "Anistia": {
                return 10L;
            }
            case "Remiss\u00e3o": {
                return 20L;
            }
            case "Subs\u00eddio": {
                return 30L;
            }
            case "Cr\u00e9dito Presumido": {
                return 40L;
            }
            case "Altera\u00e7\u00e3o de Al\u00edquota ou Modifica\u00e7\u00e3o de Base de C\u00e1lculo": {
                return 50L;
            }
            case "Outros Benef\u00edcios": {
                return 60L;
            }
        }
        return 0L;
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addId(params);
        this.addEntidade(params);
        this.addExercicio(params);
        this.addSetorBeneficiario(params);
        this.addTributo(params);
        this.addCompensacao(params);
        this.addTipoTributo(params);
        this.addTipoModalidade(params);
        this.addDataInicio(params);
        this.addDataFim(params);
        return params;
    }

    private void addId(MapSqlParameterSource params) {
        if (Objects.nonNull(this.id)) {
            params.addValue("id", (Object)this.id, 2);
        }
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void addSetorBeneficiario(MapSqlParameterSource params) {
        if (Objects.nonNull(this.setorBeneficiario)) {
            params.addValue("setorBeneficiario", (Object)this.setorBeneficiario, 12);
        }
    }

    private void addTributo(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tributo)) {
            params.addValue("tributo", (Object)this.tributo, 12);
        }
    }

    private void addCompensacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.compensacao)) {
            params.addValue("compensacao", (Object)this.compensacao, 12);
        }
    }

    private void addTipoTributo(MapSqlParameterSource params) {
        if (Objects.nonNull(this.descTipoTributo)) {
            params.addValue("descTipoTributo", (Object)this.descTipoTributo, 12);
        }
    }

    private void addTipoModalidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.descTipoModalidade)) {
            params.addValue("descTipoModalidade", (Object)this.descTipoModalidade, 12);
        }
    }

    private void addDataInicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataInicio)) {
            params.addValue("dataInicio", (Object)this.dataInicio.format(DATE_FORMAT), 91);
        }
    }

    private void addDataFim(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataFim)) {
            params.addValue("dataFim", (Object)this.dataFim.format(DATE_FORMAT), 91);
        }
    }

    @Generated
    public static RenunciaReceitaParamsBuilder builder() {
        return new RenunciaReceitaParamsBuilder();
    }

    @Generated
    public String toString() {
        return "RenunciaReceitaParams(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", setorBeneficiario=" + this.getSetorBeneficiario() + ", tributo=" + this.getTributo() + ", compensacao=" + this.getCompensacao() + ", descTipoTributo=" + this.getDescTipoTributo() + ", descTipoModalidade=" + this.getDescTipoModalidade() + ", exportType=" + this.getExportType() + ", dataInicio=" + this.getDataInicio() + ", dataFim=" + this.getDataFim() + ")";
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setSetorBeneficiario(String setorBeneficiario) {
        this.setorBeneficiario = setorBeneficiario;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setCompensacao(String compensacao) {
        this.compensacao = compensacao;
    }

    @Generated
    public void setDescTipoTributo(String descTipoTributo) {
        this.descTipoTributo = descTipoTributo;
    }

    @Generated
    public void setDescTipoModalidade(String descTipoModalidade) {
        this.descTipoModalidade = descTipoModalidade;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public void setDataInicio(LocalDate dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Generated
    public void setDataFim(LocalDate dataFim) {
        this.dataFim = dataFim;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenunciaReceitaParams)) {
            return false;
        }
        RenunciaReceitaParams other = (RenunciaReceitaParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Optional this$id = this.getId();
        Optional other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Optional this$entidade = this.getEntidade();
        Optional other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Optional this$exercicio = this.getExercicio();
        Optional other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Optional this$setorBeneficiario = this.getSetorBeneficiario();
        Optional other$setorBeneficiario = other.getSetorBeneficiario();
        if (this$setorBeneficiario == null ? other$setorBeneficiario != null : !((Object)this$setorBeneficiario).equals(other$setorBeneficiario)) {
            return false;
        }
        Optional this$tributo = this.getTributo();
        Optional other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !((Object)this$tributo).equals(other$tributo)) {
            return false;
        }
        Optional this$compensacao = this.getCompensacao();
        Optional other$compensacao = other.getCompensacao();
        if (this$compensacao == null ? other$compensacao != null : !((Object)this$compensacao).equals(other$compensacao)) {
            return false;
        }
        Optional this$descTipoTributo = this.getDescTipoTributo();
        Optional other$descTipoTributo = other.getDescTipoTributo();
        if (this$descTipoTributo == null ? other$descTipoTributo != null : !((Object)this$descTipoTributo).equals(other$descTipoTributo)) {
            return false;
        }
        Optional this$descTipoModalidade = this.getDescTipoModalidade();
        Optional other$descTipoModalidade = other.getDescTipoModalidade();
        if (this$descTipoModalidade == null ? other$descTipoModalidade != null : !((Object)this$descTipoModalidade).equals(other$descTipoModalidade)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        if (this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType)) {
            return false;
        }
        LocalDate this$dataInicio = this.getDataInicio();
        LocalDate other$dataInicio = other.getDataInicio();
        if (this$dataInicio == null ? other$dataInicio != null : !((Object)this$dataInicio).equals(other$dataInicio)) {
            return false;
        }
        LocalDate this$dataFim = this.getDataFim();
        LocalDate other$dataFim = other.getDataFim();
        return !(this$dataFim == null ? other$dataFim != null : !((Object)this$dataFim).equals(other$dataFim));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RenunciaReceitaParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Optional $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Optional $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Optional $setorBeneficiario = this.getSetorBeneficiario();
        result = result * 59 + ($setorBeneficiario == null ? 43 : ((Object)$setorBeneficiario).hashCode());
        Optional $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : ((Object)$tributo).hashCode());
        Optional $compensacao = this.getCompensacao();
        result = result * 59 + ($compensacao == null ? 43 : ((Object)$compensacao).hashCode());
        Optional $descTipoTributo = this.getDescTipoTributo();
        result = result * 59 + ($descTipoTributo == null ? 43 : ((Object)$descTipoTributo).hashCode());
        Optional $descTipoModalidade = this.getDescTipoModalidade();
        result = result * 59 + ($descTipoModalidade == null ? 43 : ((Object)$descTipoModalidade).hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        LocalDate $dataInicio = this.getDataInicio();
        result = result * 59 + ($dataInicio == null ? 43 : ((Object)$dataInicio).hashCode());
        LocalDate $dataFim = this.getDataFim();
        result = result * 59 + ($dataFim == null ? 43 : ((Object)$dataFim).hashCode());
        return result;
    }

    @Generated
    public RenunciaReceitaParams() {
    }

    @Generated
    public RenunciaReceitaParams(Long id, Long entidade, Long exercicio, String setorBeneficiario, String tributo, String compensacao, String descTipoTributo, String descTipoModalidade, String exportType, LocalDate dataInicio, LocalDate dataFim) {
        this.id = id;
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.setorBeneficiario = setorBeneficiario;
        this.tributo = tributo;
        this.compensacao = compensacao;
        this.descTipoTributo = descTipoTributo;
        this.descTipoModalidade = descTipoModalidade;
        this.exportType = exportType;
        this.dataInicio = dataInicio;
        this.dataFim = dataFim;
    }
}

