/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource.params;

import br.com.elotech.portaltransparencia.contabportal.resource.params.EmpresaTerceirizadaFuncionarioParams;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class EmpresaTerceirizadaFuncionarioParams {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private String cnpj;
    private String cargo;
    private String lotacao;
    private String trabalhador;
    private String empresa;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataInicial;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataFinal;

    public Optional<LocalDate> getDataInicial() {
        return Optional.ofNullable(this.dataInicial);
    }

    public Optional<LocalDate> getDataFinal() {
        return Optional.ofNullable(this.dataFinal);
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addDataInicial(params);
        this.addDataFinal(params);
        return params;
    }

    private void addDataInicial(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataInicial)) {
            params.addValue("dataInicial", (Object)this.dataInicial.format(DATE_FORMAT), 91);
        }
    }

    private void addDataFinal(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataFinal)) {
            params.addValue("dataFinal", (Object)this.dataFinal.format(DATE_FORMAT), 91);
        }
    }

    @Generated
    public static EmpresaTerceirizadaFuncionarioParamsBuilder builder() {
        return new EmpresaTerceirizadaFuncionarioParamsBuilder();
    }

    @Generated
    public String toString() {
        return "EmpresaTerceirizadaFuncionarioParams(cnpj=" + this.getCnpj() + ", cargo=" + this.getCargo() + ", lotacao=" + this.getLotacao() + ", trabalhador=" + this.getTrabalhador() + ", empresa=" + this.getEmpresa() + ", dataInicial=" + this.getDataInicial() + ", dataFinal=" + this.getDataFinal() + ")";
    }

    @Generated
    public EmpresaTerceirizadaFuncionarioParams() {
    }

    @Generated
    public EmpresaTerceirizadaFuncionarioParams(String cnpj, String cargo, String lotacao, String trabalhador, String empresa, LocalDate dataInicial, LocalDate dataFinal) {
        this.cnpj = cnpj;
        this.cargo = cargo;
        this.lotacao = lotacao;
        this.trabalhador = trabalhador;
        this.empresa = empresa;
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
    }

    @Generated
    public String getCnpj() {
        return this.cnpj;
    }

    @Generated
    public String getCargo() {
        return this.cargo;
    }

    @Generated
    public String getLotacao() {
        return this.lotacao;
    }

    @Generated
    public String getTrabalhador() {
        return this.trabalhador;
    }

    @Generated
    public String getEmpresa() {
        return this.empresa;
    }

    @Generated
    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @Generated
    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    @Generated
    public void setLotacao(String lotacao) {
        this.lotacao = lotacao;
    }

    @Generated
    public void setTrabalhador(String trabalhador) {
        this.trabalhador = trabalhador;
    }

    @Generated
    public void setEmpresa(String empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmpresaTerceirizadaFuncionarioParams)) {
            return false;
        }
        EmpresaTerceirizadaFuncionarioParams other = (EmpresaTerceirizadaFuncionarioParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$cnpj = this.getCnpj();
        String other$cnpj = other.getCnpj();
        if (this$cnpj == null ? other$cnpj != null : !this$cnpj.equals(other$cnpj)) {
            return false;
        }
        String this$cargo = this.getCargo();
        String other$cargo = other.getCargo();
        if (this$cargo == null ? other$cargo != null : !this$cargo.equals(other$cargo)) {
            return false;
        }
        String this$lotacao = this.getLotacao();
        String other$lotacao = other.getLotacao();
        if (this$lotacao == null ? other$lotacao != null : !this$lotacao.equals(other$lotacao)) {
            return false;
        }
        String this$trabalhador = this.getTrabalhador();
        String other$trabalhador = other.getTrabalhador();
        if (this$trabalhador == null ? other$trabalhador != null : !this$trabalhador.equals(other$trabalhador)) {
            return false;
        }
        String this$empresa = this.getEmpresa();
        String other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !this$empresa.equals(other$empresa)) {
            return false;
        }
        Optional this$dataInicial = this.getDataInicial();
        Optional other$dataInicial = other.getDataInicial();
        if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
            return false;
        }
        Optional this$dataFinal = this.getDataFinal();
        Optional other$dataFinal = other.getDataFinal();
        return !(this$dataFinal == null ? other$dataFinal != null : !((Object)this$dataFinal).equals(other$dataFinal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmpresaTerceirizadaFuncionarioParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cnpj = this.getCnpj();
        result = result * 59 + ($cnpj == null ? 43 : $cnpj.hashCode());
        String $cargo = this.getCargo();
        result = result * 59 + ($cargo == null ? 43 : $cargo.hashCode());
        String $lotacao = this.getLotacao();
        result = result * 59 + ($lotacao == null ? 43 : $lotacao.hashCode());
        String $trabalhador = this.getTrabalhador();
        result = result * 59 + ($trabalhador == null ? 43 : $trabalhador.hashCode());
        String $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : $empresa.hashCode());
        Optional $dataInicial = this.getDataInicial();
        result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
        Optional $dataFinal = this.getDataFinal();
        result = result * 59 + ($dataFinal == null ? 43 : ((Object)$dataFinal).hashCode());
        return result;
    }
}

