/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoAnexosDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoAnulacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDocumentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoEmLiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoItensDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoLinksDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoLiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoMovimentacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoPagamentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoRestosAPagarDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoRetencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhosListaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.service.EmpenhoService;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.report.ReportUtils;
import br.com.elotech.portaltransparencia.web.rest.params.EmpenhoParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/empenhos"})
public class EmpenhoResource {
    private final EmpenhoService empenhoService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final EntidadeContabilidadeService entidadeService;

    @GetMapping(value={"/lista"})
    public Page<EmpenhosListaDTO> getEmpenhos(Pageable pageable, EmpenhoParams params) {
        return this.empenhoService.getEmpenhosSearch(pageable, params);
    }

    @GetMapping(value={"/report"})
    public ModelAndView getEmpenhosExport(HttpServletRequest request, HttpServletResponse response, Pageable pageable, EmpenhoParams params) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.empenhoService.getEmpenhosSearch((Pageable)pageRequest, params);
        Entidade entidade = (Entidade)this.entidadeRepository.findOne((Object)this.entidadeService.getEntidadeSelecionada(params.getEntidade()).getId());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidade.getNome());
        reportParam.setReportTitle("Listagem de Empenhos");
        reportParam.setClazzDTO(EmpenhosListaDTO.class);
        reportParam.setHeaderFields("Entidade,Empenho/Exercicio,Data,Fornecedor,Historico/Justificativa,Valor Empenho,Valor Anulado,Valor Liquidado,Valor Retido,Valor Pago,A Pagar");
        reportParam.setFields("entidade,empenhoExercicio,data,nome,historico,valorEmpenhado,valorAnulado,valorLiquidado,valorRetido,valorPago,valorAPagar");
        float[] fieldsPerc = new float[]{0.9f, 0.9f, 0.9f, 1.0f, 1.8f, 0.9f, 0.9f, 0.9f, 0.9f, 0.9f, 0.9f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{10, 10, 11, 50, 300, 15, 15, 15, 15, 15, 15};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setSumFields("valorEmpenhado,valorAnulado,valorLiquidado,valorRetido,valorPago,valorAPagar");
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/totais"})
    public EmpenhosListaDTO getEmpenhosTotal(EmpenhoParams params) {
        return this.empenhoService.getEmpenhosTotal(params);
    }

    @GetMapping(value={"/detalhe"})
    public EmpenhoDTO getEmpenhoDetalhe(EmpenhoParams params) {
        return this.empenhoService.getEmpenhoDetalhe(params);
    }

    @GetMapping(value={"/detalhe/itens"})
    public List<EmpenhoItensDTO> getEmpenhoDetalheItens(EmpenhoParams params) {
        return this.empenhoService.getEmpenhoDetalheItens(params);
    }

    @GetMapping(value={"/detalhe/anulacoes"})
    public List<EmpenhoAnulacaoDTO> getEmpenhoDetalheAnulacao(EmpenhoParams params) {
        return this.empenhoService.getEmpenhoDetalheAnulacao(params);
    }

    @GetMapping(value={"/detalhe/liquidacoes"})
    public List<EmpenhoLiquidacaoDTO> getEmpenhoDetalheLiquidacao(EmpenhoParams params) {
        return this.empenhoService.getEmpenhoDetalheLiquidacao(params);
    }

    @GetMapping(value={"/detalhe/liquidacoesdocumentos"})
    public List<EmpenhoDocumentoDTO> getEmpenhoDetalheDocumentos(EmpenhoParams params) {
        return this.empenhoService.getEmpenhoDetalheDocumentos(params);
    }

    @GetMapping(value={"/detalhe/pagamentos"})
    public List<EmpenhoPagamentoDTO> getEmpenhoDetalhePagamentos(EmpenhoParams params) {
        return this.empenhoService.getEmpenhoDetalhePagamento(params);
    }

    @GetMapping(value={"/detalhe/retencoes"})
    public List<EmpenhoRetencaoDTO> getEmpenhoDetalheRetencoes(EmpenhoParams params) {
        return this.empenhoService.getEmpenhoDetalheRetencao(params);
    }

    @GetMapping(value={"/detalhe/movimentacao"})
    public Page<EmpenhoMovimentacaoDTO> getEmpenhoDetalheMovimentacao(Pageable pageable, EmpenhoParams params) {
        return this.empenhoService.getEmpenhoDetalheMovimentacao(pageable, params);
    }

    @GetMapping(value={"/detalhe/anexos"})
    public List<EmpenhoAnexosDTO> getEmpenhoDetalheAnexos(EmpenhoParams params) {
        return this.empenhoService.getEmpenhoDetalheAnexos(params);
    }

    @GetMapping(value={"/detalhe/item"})
    public EmpenhoItensDTO getEmpenhoDetalheItem(EmpenhoParams params) {
        return this.empenhoService.getEmpenhoDetalheItem(params);
    }

    @GetMapping(value={"/detalhe/links"})
    public List<EmpenhoLinksDTO> getEmpenhoDetalheLinks(EmpenhoParams params) {
        return this.empenhoService.getEmpenhoDetalheLinks(params);
    }

    @GetMapping(value={"/detalhe/em-liquidacao"})
    public List<EmpenhoEmLiquidacaoDTO> getEmpenhoDetalheEmLiquidacao(EmpenhoParams params) {
        return this.empenhoService.getEmpenhoDetalheEmLiquidacao(params);
    }

    @GetMapping(value={"/nota-empenho"})
    public void getNotaEmpenho(HttpServletResponse response, EmpenhoParams params) throws IOException {
        ReportUtils.writePdfToResponse((HttpServletResponse)response, (byte[])this.empenhoService.gerarRelatorioPdf(params), (String)"Nota-Empenho.pdf");
    }

    @GetMapping(value={"/restos-a-pagar"})
    public Page<EmpenhoRestosAPagarDTO> getRestosAPagar(Pageable pageable, EmpenhoParams params) {
        return this.empenhoService.getEmpenhoRestosAPagar(pageable, params);
    }

    @GetMapping(value={"/restos-a-pagar/report"})
    public ModelAndView getRestosAPagarExport(HttpServletRequest request, HttpServletResponse response, Pageable pageable, EmpenhoParams params) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.empenhoService.getEmpenhoRestosAPagar((Pageable)pageRequest, params);
        ReportParam reportParam = new ReportParam();
        reportParam.setReportTitle("Listagem de Restos a Pagar");
        reportParam.setClazzDTO(EmpenhoRestosAPagarDTO.class);
        if (params.getTipoPesquisa().equalsIgnoreCase("Processados")) {
            reportParam.setHeaderFields("Empenho,Data,Fonte de Recursos,Fornecedor,Valor Inscrito,Valor Cancelado,Valor Pago");
            reportParam.setFields("empenhoExercicio,dataEmissao,descricaoFonte,cnpjNome,proc,canceladoProc,pagoProc");
            float[] fieldsPerc = new float[]{0.6f, 0.6f, 1.2f, 2.0f, 0.8f, 0.8f, 0.8f};
            int[] fieldTab = new int[]{60, 60, 120, 200, 80, 80, 80};
            reportParam.setWidthsFieldsPerc(fieldsPerc);
            reportParam.setWidthsFieldsTab(fieldTab);
        } else {
            reportParam.setHeaderFields("Empenho,Data,Fonte de Recursos,Fornecedor,Valor Inscrito,Valor Liquidado,Valor Cancelado,Valor Pago");
            reportParam.setFields("empenhoExercicio,dataEmissao,descricaoFonte,cnpjNome,aproc,liquidado,canceladoAProc,pagoAProc");
            float[] fieldsPerc = new float[]{0.6f, 0.6f, 1.2f, 2.0f, 0.8f, 0.8f, 0.8f, 0.8f};
            int[] fieldTab = new int[]{60, 60, 120, 200, 80, 80, 80, 80};
            reportParam.setWidthsFieldsPerc(fieldsPerc);
            reportParam.setWidthsFieldsTab(fieldTab);
        }
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @Generated
    public EmpenhoResource(EmpenhoService empenhoService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository, EntidadeContabilidadeService entidadeService) {
        this.empenhoService = empenhoService;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.entidadeService = entidadeService;
    }
}

