/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.TotalAcesso;
import java.time.LocalDate;
import java.util.Optional;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

@Repository(value="totalAcessoRepository")
public interface TotalAcessoRepository
extends CrudRepository<TotalAcesso, Long>,
QuerydslPredicateExecutor<TotalAcesso> {
    @Query(value="SELECT COALESCE(MAX(t.id)+1, 1) AS ID FROM TotalAcesso t")
    public Long getNextId();

    @Query(value="SELECT SUM(t.totalAcessos) FROM TotalAcesso t")
    public Long getTotalAcessos();

    @Query(value="SELECT SUM(t.totalDiarioOficial) FROM TotalAcesso t")
    public Long getTotalAcessosDiarioOficial();

    public Optional<TotalAcesso> findByData(LocalDate var1);

    @Modifying
    @Query(value="lock table eloportaltotalacessos  IN EXCLUSIVE MODE", nativeQuery=true)
    public void lockTable();
}

