/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.contabilidade.client.DotacaoFeignClient;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.orcamento.client.PPAFeignClient;
import br.com.elotech.orcamento.client.dto.DespesaPadraoTCEDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DespesaDetalhadaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DespesaPorNivelDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.DespesaPorNivelRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.DespesaParams;
import br.com.elotech.portaltransparencia.dto.DotacaoSaldoLoadedDTO;
import java.time.Month;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class DespesaPorNivelOxyRepository
implements DespesaPorNivelRepository {
    private static final String POINT = ".";
    private static final String PR = "PR";
    private static final Long OPERACAO = 3L;
    private static final Long ATIVIDADE = 2L;
    private static final Long PROJETO = 1L;
    private DotacaoFeignClient dotacaoFeignClient;
    private PPAFeignClient ppaFeignClient;

    public List<DespesaDetalhadaDTO> getDepesaAgrupaNivel(DespesaParams params) {
        List dotacoes = this.dotacaoFeignClient.findAllDotacaoSaldoLoaded(params.getEntidade(), params.getExercicio());
        List dtos = this.groupDadosDetalhadosByNivel(params, dotacoes);
        return dtos.stream().sorted(Comparator.comparing(DespesaDetalhadaDTO::getProgramatica)).collect(Collectors.toList());
    }

    public List<DespesaPorNivelDTO> getDespesaPorNivel(Long entidade, Long exercicio, String nivelLei, String tipo) {
        List dotacoes = this.dotacaoFeignClient.findAllDotacaoSaldoLoaded(entidade, exercicio);
        List dtos = this.groupDadosByNivelLei(nivelLei, dotacoes);
        return dtos.stream().sorted(Comparator.comparing(DespesaPorNivelDTO::getCodigo)).collect(Collectors.toList());
    }

    public List<DespesaPorNivelDTO> getDespesaPorFonteRecurso(Long entidade, Long exercicio) {
        List dotacoes = this.dotacaoFeignClient.findAllDotacaoSaldoLoaded(entidade, exercicio);
        List dtos = this.groupDadosByNivelLei("FR", dotacoes);
        return dtos.stream().sorted(Comparator.comparing(DespesaPorNivelDTO::getCodigoLong)).collect(Collectors.toList());
    }

    public List<DespesaPorNivelDTO> getDespesaPorEsferaAdministrativa(Long entidade, Long exercicio) {
        List dotacoes = this.dotacaoFeignClient.findAllDotacaoSaldoLoaded(entidade, exercicio);
        ArrayList dtos = new ArrayList();
        dotacoes.forEach(dotacao -> {
            String descricaoEsfera = DespesaPorNivelDTO.getDescricaoByNivelProgramatica((DotacaoSaldoLoadedDTO)dotacao, (String)"EA");
            DespesaPorNivelDTO despesaPorNivel = dtos.stream().filter(dto -> dto.getDescricao().equals(descricaoEsfera)).findFirst().orElseGet(() -> {
                DespesaPorNivelDTO newDTO = new DespesaPorNivelDTO();
                newDTO.setDescricao(descricaoEsfera);
                dtos.add(newDTO);
                return newDTO;
            });
            this.sumValores(despesaPorNivel, dotacao);
        });
        return dtos.stream().sorted(Comparator.comparing(DespesaPorNivelDTO::getDescricao)).collect(Collectors.toList());
    }

    public List<DespesaDetalhadaDTO> getDepesaDetalhada(Long entidade, Long exercicio) {
        List dotacoes = this.dotacaoFeignClient.findAllDotacaoSaldoLoaded(entidade, exercicio);
        List despesas = this.ppaFeignClient.findAllDespesasPadraoByUfAndDataBetweenAndEntidades(PR, DateUtils.firstDayOfMonth((int)Month.JANUARY.getValue(), (int)exercicio.intValue()), DateUtils.lastDayOfMonth((int)Month.DECEMBER.getValue(), (int)exercicio.intValue()), List.of(entidade));
        ArrayList dtos = new ArrayList();
        dotacoes.forEach(dotacao -> {
            DespesaDetalhadaDTO dtoOrgao = this.createDetalheOrgao(dtos, dotacao);
            DespesaDetalhadaDTO dtoUnidade = this.createDetalheUnidade(dtos, dotacao, dtoOrgao);
            DespesaDetalhadaDTO dtoFuncao = this.createDetalheFuncao(dtos, dotacao, dtoUnidade);
            DespesaDetalhadaDTO dtoSubfuncao = this.createDetalheSubfuncao(dtos, dotacao, dtoFuncao);
            DespesaDetalhadaDTO dtoPrograma = this.createDetalhePrograma(dtos, dotacao, dtoSubfuncao);
            DespesaDetalhadaDTO dtoProjeto = this.createDetalheProjeto(dtos, dotacao, dtoPrograma);
            this.createDetalheDespesa(dtos, dotacao, dtoProjeto, despesas);
        });
        return dtos.stream().sorted(Comparator.comparing(DespesaDetalhadaDTO::getProgramatica)).collect(Collectors.toList());
    }

    private DespesaDetalhadaDTO createDetalheOrgao(List<DespesaDetalhadaDTO> dtos, DotacaoSaldoLoadedDTO dotacao) {
        DespesaDetalhadaDTO despesaDetalhada = dtos.stream().filter(dto -> dto.getProgramatica().equals(DespesaDetalhadaDTO.getProgramaticaByNivelProgramatica((DotacaoSaldoLoadedDTO)dotacao, (Long)DespesaDetalhadaDTO.ORGAO))).findFirst().orElseGet(() -> {
            DespesaDetalhadaDTO newDTO = DespesaDetalhadaDTO.ofDTO((DotacaoSaldoLoadedDTO)dotacao, (Long)DespesaDetalhadaDTO.ORGAO);
            dtos.add(newDTO);
            return newDTO;
        });
        this.sumValores(despesaDetalhada, dotacao);
        return despesaDetalhada;
    }

    private DespesaDetalhadaDTO createDetalheUnidade(List<DespesaDetalhadaDTO> dtos, DotacaoSaldoLoadedDTO dotacao, DespesaDetalhadaDTO dtoOrgao) {
        String programatica = dtoOrgao.getProgramatica() + POINT + DespesaDetalhadaDTO.getProgramaticaByNivelProgramatica((DotacaoSaldoLoadedDTO)dotacao, (Long)DespesaDetalhadaDTO.UNIDADE_ORCAMENTARIA);
        DespesaDetalhadaDTO despesaDetalhada = dtos.stream().filter(dto -> dto.getProgramatica().equals(programatica)).findFirst().orElseGet(() -> {
            DespesaDetalhadaDTO newDTO = DespesaDetalhadaDTO.ofProgramatica((DotacaoSaldoLoadedDTO)dotacao, (String)programatica, (Long)DespesaDetalhadaDTO.UNIDADE_ORCAMENTARIA);
            dtos.add(newDTO);
            return newDTO;
        });
        this.sumValores(despesaDetalhada, dotacao);
        return despesaDetalhada;
    }

    private DespesaDetalhadaDTO createDetalheFuncao(List<DespesaDetalhadaDTO> dtos, DotacaoSaldoLoadedDTO dotacao, DespesaDetalhadaDTO dtoUnidad) {
        String programatica = dtoUnidad.getProgramatica() + POINT + DespesaDetalhadaDTO.getProgramaticaByNivelProgramatica((DotacaoSaldoLoadedDTO)dotacao, (Long)DespesaDetalhadaDTO.FUNCAO);
        DespesaDetalhadaDTO despesaDetalhada = dtos.stream().filter(dto -> dto.getProgramatica().equals(programatica)).findFirst().orElseGet(() -> {
            DespesaDetalhadaDTO newDTO = DespesaDetalhadaDTO.ofProgramatica((DotacaoSaldoLoadedDTO)dotacao, (String)programatica, (Long)DespesaDetalhadaDTO.FUNCAO);
            dtos.add(newDTO);
            return newDTO;
        });
        this.sumValores(despesaDetalhada, dotacao);
        return despesaDetalhada;
    }

    private DespesaDetalhadaDTO createDetalheSubfuncao(List<DespesaDetalhadaDTO> dtos, DotacaoSaldoLoadedDTO dotacao, DespesaDetalhadaDTO dtoFuncao) {
        String programatica = dtoFuncao.getProgramatica() + POINT + DespesaDetalhadaDTO.getProgramaticaByNivelProgramatica((DotacaoSaldoLoadedDTO)dotacao, (Long)DespesaDetalhadaDTO.SUBFUNCAO);
        DespesaDetalhadaDTO despesaDetalhada = dtos.stream().filter(dto -> dto.getProgramatica().equals(programatica)).findFirst().orElseGet(() -> {
            DespesaDetalhadaDTO newDTO = DespesaDetalhadaDTO.ofProgramatica((DotacaoSaldoLoadedDTO)dotacao, (String)programatica, (Long)DespesaDetalhadaDTO.SUBFUNCAO);
            dtos.add(newDTO);
            return newDTO;
        });
        this.sumValores(despesaDetalhada, dotacao);
        return despesaDetalhada;
    }

    private DespesaDetalhadaDTO createDetalhePrograma(List<DespesaDetalhadaDTO> dtos, DotacaoSaldoLoadedDTO dotacao, DespesaDetalhadaDTO dtoSubfuncao) {
        String programatica = dtoSubfuncao.getProgramatica() + POINT + DespesaDetalhadaDTO.getProgramaticaByNivelProgramatica((DotacaoSaldoLoadedDTO)dotacao, (Long)DespesaDetalhadaDTO.PROGRAMA);
        DespesaDetalhadaDTO despesaDetalhada = dtos.stream().filter(dto -> dto.getProgramatica().equals(programatica)).findFirst().orElseGet(() -> {
            DespesaDetalhadaDTO newDTO = DespesaDetalhadaDTO.ofProgramatica((DotacaoSaldoLoadedDTO)dotacao, (String)programatica, (Long)DespesaDetalhadaDTO.PROGRAMA);
            dtos.add(newDTO);
            return newDTO;
        });
        this.sumValores(despesaDetalhada, dotacao);
        return despesaDetalhada;
    }

    private DespesaDetalhadaDTO createDetalheProjeto(List<DespesaDetalhadaDTO> dtos, DotacaoSaldoLoadedDTO dotacao, DespesaDetalhadaDTO dtoPrograma) {
        String programatica = dtoPrograma.getProgramatica() + POINT + DespesaDetalhadaDTO.getProgramaticaByNivelProgramatica((DotacaoSaldoLoadedDTO)dotacao, (Long)DespesaDetalhadaDTO.PROJETO_ATIVIDADE);
        DespesaDetalhadaDTO despesaDetalhada = dtos.stream().filter(dto -> dto.getProgramatica().equals(programatica)).findFirst().orElseGet(() -> {
            DespesaDetalhadaDTO newDTO = DespesaDetalhadaDTO.ofProgramatica((DotacaoSaldoLoadedDTO)dotacao, (String)programatica, (Long)DespesaDetalhadaDTO.PROJETO_ATIVIDADE);
            dtos.add(newDTO);
            return newDTO;
        });
        this.sumValores(despesaDetalhada, dotacao);
        return despesaDetalhada;
    }

    private void createDetalheDespesa(List<DespesaDetalhadaDTO> dtos, DotacaoSaldoLoadedDTO dotacao, DespesaDetalhadaDTO dtoProjeto, List<DespesaPadraoTCEDTO> despesasPadraoTCE) {
        String codigoCategoria = DespesaDetalhadaDTO.getProgramaticaByNivelProgramatica((DotacaoSaldoLoadedDTO)dotacao, (Long)DespesaDetalhadaDTO.CATEGORIA);
        String programaticaCategoria = dtoProjeto.getProgramatica() + POINT + codigoCategoria;
        DespesaPadraoTCEDTO despesaTCECategoria = despesasPadraoTCE.stream().filter(d -> d.getNivel().equals(DespesaDetalhadaDTO.CATEGORIA_NIVEL) && d.getCodigo().startsWith(codigoCategoria)).findFirst().orElse(new DespesaPadraoTCEDTO());
        DespesaDetalhadaDTO despesaDetalhada = dtos.stream().filter(dto -> dto.getProgramatica().equals(programaticaCategoria)).findFirst().orElseGet(() -> {
            DespesaDetalhadaDTO newDTO = DespesaDetalhadaDTO.ofDespesa((DespesaPadraoTCEDTO)despesaTCECategoria, (String)programaticaCategoria, (Long)DespesaDetalhadaDTO.CATEGORIA);
            dtos.add(newDTO);
            return newDTO;
        });
        this.sumValores(despesaDetalhada, dotacao);
        String codigoGrupo = DespesaDetalhadaDTO.getProgramaticaByNivelProgramatica((DotacaoSaldoLoadedDTO)dotacao, (Long)DespesaDetalhadaDTO.GRUPO_NATUREZA);
        String programaticaGrupo = programaticaCategoria + POINT + codigoGrupo;
        DespesaPadraoTCEDTO despesaTCEGrupo = despesasPadraoTCE.stream().filter(d -> d.getNivel().equals(DespesaDetalhadaDTO.GRUPO_NATUREZA_NIVEL) && d.getCodigo().startsWith(codigoCategoria + codigoGrupo)).findFirst().orElse(new DespesaPadraoTCEDTO());
        despesaDetalhada = dtos.stream().filter(dto -> dto.getProgramatica().equals(programaticaGrupo)).findFirst().orElseGet(() -> {
            DespesaDetalhadaDTO newDTO = DespesaDetalhadaDTO.ofDespesa((DespesaPadraoTCEDTO)despesaTCEGrupo, (String)programaticaGrupo, (Long)DespesaDetalhadaDTO.GRUPO_NATUREZA);
            dtos.add(newDTO);
            return newDTO;
        });
        this.sumValores(despesaDetalhada, dotacao);
        String codigoModalidade = DespesaDetalhadaDTO.getProgramaticaByNivelProgramatica((DotacaoSaldoLoadedDTO)dotacao, (Long)DespesaDetalhadaDTO.MODALIDADE);
        String programaticaModalidade = programaticaGrupo + POINT + codigoModalidade;
        DespesaPadraoTCEDTO despesaTCEModalidade = despesasPadraoTCE.stream().filter(d -> d.getNivel().equals(DespesaDetalhadaDTO.MODALIDADE_NIVEL) && d.getCodigo().startsWith(codigoCategoria + codigoGrupo + codigoModalidade)).findFirst().orElse(new DespesaPadraoTCEDTO());
        despesaDetalhada = dtos.stream().filter(dto -> dto.getProgramatica().equals(programaticaModalidade)).findFirst().orElseGet(() -> {
            DespesaDetalhadaDTO newDTO = DespesaDetalhadaDTO.ofDespesa((DespesaPadraoTCEDTO)despesaTCEModalidade, (String)programaticaModalidade, (Long)DespesaDetalhadaDTO.MODALIDADE);
            dtos.add(newDTO);
            return newDTO;
        });
        this.sumValores(despesaDetalhada, dotacao);
        String codigoElemento = DespesaDetalhadaDTO.getProgramaticaByNivelProgramatica((DotacaoSaldoLoadedDTO)dotacao, (Long)DespesaDetalhadaDTO.ELEMENTO);
        String programaticaElemento = programaticaModalidade + POINT + codigoElemento;
        DespesaPadraoTCEDTO despesaTCEElemento = despesasPadraoTCE.stream().filter(d -> d.getNivel().equals(DespesaDetalhadaDTO.ELEMENTO_NIVEL) && d.getCodigo().startsWith(codigoCategoria + codigoGrupo + codigoModalidade + codigoElemento)).findFirst().orElse(new DespesaPadraoTCEDTO());
        despesaDetalhada = dtos.stream().filter(dto -> dto.getProgramatica().equals(programaticaElemento)).findFirst().orElseGet(() -> {
            DespesaDetalhadaDTO newDTO = DespesaDetalhadaDTO.ofDespesa((DespesaPadraoTCEDTO)despesaTCEElemento, (String)programaticaElemento, (Long)DespesaDetalhadaDTO.ELEMENTO);
            newDTO.setAceitaMovimentacao(SimNao.SIM.getSigla());
            dtos.add(newDTO);
            return newDTO;
        });
        this.sumValores(despesaDetalhada, dotacao);
    }

    private List<DespesaPorNivelDTO> groupDadosByNivelLei(String nivelLei, List<DotacaoSaldoLoadedDTO> dotacoes) {
        ArrayList<DespesaPorNivelDTO> dtos = new ArrayList<DespesaPorNivelDTO>();
        dotacoes.forEach(dotacao -> {
            DespesaPorNivelDTO despesaPorNivel = dtos.stream().filter(dto -> dto.getCodigo().equals(DespesaPorNivelDTO.getCodigoByNivelProgramatica((DotacaoSaldoLoadedDTO)dotacao, (String)nivelLei))).findFirst().orElseGet(() -> {
                DespesaPorNivelDTO newDTO = DespesaPorNivelDTO.ofDTO((DotacaoSaldoLoadedDTO)dotacao, (String)nivelLei);
                dtos.add(newDTO);
                return newDTO;
            });
            this.sumValores(despesaPorNivel, dotacao);
        });
        return dtos;
    }

    private void sumValores(DespesaPorNivelDTO despesaPorNivel, DotacaoSaldoLoadedDTO dotacao) {
        despesaPorNivel.setValorEmpenhado(despesaPorNivel.getValorEmpenhado().add(dotacao.getValorEmpenhado()));
        despesaPorNivel.setValorLiquidado(despesaPorNivel.getValorLiquidado().add(dotacao.getValorLiquidado()));
        despesaPorNivel.setValorOrcado(despesaPorNivel.getValorOrcado().add(dotacao.getValorPrevisto()));
        despesaPorNivel.setValorPago(despesaPorNivel.getValorPago().add(dotacao.getValorPago()));
        despesaPorNivel.setValorRetido(despesaPorNivel.getValorRetido().add(dotacao.getValorRetido()));
    }

    private List<DespesaDetalhadaDTO> groupDadosDetalhadosByNivel(DespesaParams params, List<DotacaoSaldoLoadedDTO> dotacoes) {
        ArrayList<DespesaDetalhadaDTO> dtos = new ArrayList<DespesaDetalhadaDTO>();
        this.filterDespesasByProjetoAtividade(dotacoes, params).forEach(dotacao -> {
            DespesaDetalhadaDTO despesaDetalhada = dtos.stream().filter(dto -> dto.getProgramatica().equals(DespesaDetalhadaDTO.getProgramaticaByNivelProgramatica((DotacaoSaldoLoadedDTO)dotacao, (Long)params.getNivel(), (Boolean)Boolean.TRUE))).findFirst().orElseGet(() -> {
                DespesaDetalhadaDTO newDTO = DespesaDetalhadaDTO.ofDTO((DotacaoSaldoLoadedDTO)dotacao, (Long)params.getNivel(), (Boolean)Boolean.TRUE);
                dtos.add(newDTO);
                return newDTO;
            });
            this.sumValores(despesaDetalhada, dotacao);
        });
        return dtos;
    }

    private void sumValores(DespesaDetalhadaDTO despesaDetalhada, DotacaoSaldoLoadedDTO dotacao) {
        despesaDetalhada.setValorPrevisto(despesaDetalhada.getValorPrevisto().add(dotacao.getValorPrevisto()));
        despesaDetalhada.setValorEmpenhado(despesaDetalhada.getValorEmpenhado().add(dotacao.getValorEmpenhado()));
        despesaDetalhada.setValorLiquidado(despesaDetalhada.getValorLiquidado().add(dotacao.getValorLiquidado()));
        despesaDetalhada.setValorEmLiquidacao(despesaDetalhada.getValorEmLiquidacao().add(dotacao.getValorEmLiquidacao()));
        despesaDetalhada.setValorPago(despesaDetalhada.getValorPago().add(dotacao.getValorPago()).add(dotacao.getValorRetido()));
        despesaDetalhada.setValorAtualizado(despesaDetalhada.getValorAtualizado().add(dotacao.getValorAtualizado()));
        despesaDetalhada.setValorCreditosAdicionais(despesaDetalhada.getValorCreditosAdicionais().add(dotacao.getValorAtualizado().subtract(dotacao.getValorPrevisto())));
    }

    private List<DotacaoSaldoLoadedDTO> filterDespesasByProjetoAtividade(List<DotacaoSaldoLoadedDTO> dotacoes, DespesaParams params) {
        if (DespesaDetalhadaDTO.PROJETO_ATIVIDADE.equals(params.getNivel()) && PROJETO.equals(params.getNivelPrograma())) {
            return dotacoes.stream().filter(d -> d.getDotacao().getProjetoAtividade().getCodigo().startsWith("1")).collect(Collectors.toList());
        }
        if (DespesaDetalhadaDTO.PROJETO_ATIVIDADE.equals(params.getNivel()) && ATIVIDADE.equals(params.getNivelPrograma())) {
            return dotacoes.stream().filter(d -> d.getDotacao().getProjetoAtividade().getCodigo().startsWith("2")).collect(Collectors.toList());
        }
        if (DespesaDetalhadaDTO.PROJETO_ATIVIDADE.equals(params.getNivel()) && OPERACAO.equals(params.getNivelPrograma())) {
            return dotacoes.stream().filter(d -> d.getDotacao().getProjetoAtividade().getCodigo().startsWith("0")).collect(Collectors.toList());
        }
        return dotacoes;
    }

    @Generated
    public DespesaPorNivelOxyRepository(DotacaoFeignClient dotacaoFeignClient, PPAFeignClient ppaFeignClient) {
        this.dotacaoFeignClient = dotacaoFeignClient;
        this.ppaFeignClient = ppaFeignClient;
    }
}

