/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoPublicacaoDTO;
import br.com.elotech.unico.client.dto.LeiAtoPublicacaoDTO;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class VeiculoPublicacaoDTO {
    private Long id;
    private String codigo;
    private String nome;
    private LocalDate dataPublicacao;
    private String pagina;
    private Long numeroEdicao;
    private Long anoEdicao;
    private String descricao;
    private Long idArquivo;
    private String nomeArquivo;

    public VeiculoPublicacaoDTO(LeiAtoPublicacaoDTO leiAtoPublicacao) {
        this.id = leiAtoPublicacao.getId();
        this.dataPublicacao = leiAtoPublicacao.getDataPublicacao();
        this.pagina = leiAtoPublicacao.getPagina();
        this.numeroEdicao = leiAtoPublicacao.getNumeroEdicao();
        this.anoEdicao = leiAtoPublicacao.getAnoEdicao();
        this.descricao = Optional.ofNullable(leiAtoPublicacao.getVeiculoPublicacao()).map(br.com.elotech.unico.client.dto.VeiculoPublicacaoDTO::getDescricao).orElse("");
        Optional.ofNullable(leiAtoPublicacao.getArquivo()).ifPresent(arquivo -> {
            this.idArquivo = arquivo.getId();
            this.nomeArquivo = arquivo.getNome();
        });
    }

    @Generated
    public static VeiculoPublicacaoDTOBuilder builder() {
        return new VeiculoPublicacaoDTOBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCodigo() {
        return this.codigo;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public LocalDate getDataPublicacao() {
        return this.dataPublicacao;
    }

    @Generated
    public String getPagina() {
        return this.pagina;
    }

    @Generated
    public Long getNumeroEdicao() {
        return this.numeroEdicao;
    }

    @Generated
    public Long getAnoEdicao() {
        return this.anoEdicao;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getIdArquivo() {
        return this.idArquivo;
    }

    @Generated
    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setDataPublicacao(LocalDate dataPublicacao) {
        this.dataPublicacao = dataPublicacao;
    }

    @Generated
    public void setPagina(String pagina) {
        this.pagina = pagina;
    }

    @Generated
    public void setNumeroEdicao(Long numeroEdicao) {
        this.numeroEdicao = numeroEdicao;
    }

    @Generated
    public void setAnoEdicao(Long anoEdicao) {
        this.anoEdicao = anoEdicao;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setIdArquivo(Long idArquivo) {
        this.idArquivo = idArquivo;
    }

    @Generated
    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VeiculoPublicacaoDTO)) {
            return false;
        }
        VeiculoPublicacaoDTO other = (VeiculoPublicacaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$numeroEdicao = this.getNumeroEdicao();
        Long other$numeroEdicao = other.getNumeroEdicao();
        if (this$numeroEdicao == null ? other$numeroEdicao != null : !((Object)this$numeroEdicao).equals(other$numeroEdicao)) {
            return false;
        }
        Long this$anoEdicao = this.getAnoEdicao();
        Long other$anoEdicao = other.getAnoEdicao();
        if (this$anoEdicao == null ? other$anoEdicao != null : !((Object)this$anoEdicao).equals(other$anoEdicao)) {
            return false;
        }
        Long this$idArquivo = this.getIdArquivo();
        Long other$idArquivo = other.getIdArquivo();
        if (this$idArquivo == null ? other$idArquivo != null : !((Object)this$idArquivo).equals(other$idArquivo)) {
            return false;
        }
        String this$codigo = this.getCodigo();
        String other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !this$codigo.equals(other$codigo)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        LocalDate this$dataPublicacao = this.getDataPublicacao();
        LocalDate other$dataPublicacao = other.getDataPublicacao();
        if (this$dataPublicacao == null ? other$dataPublicacao != null : !((Object)this$dataPublicacao).equals(other$dataPublicacao)) {
            return false;
        }
        String this$pagina = this.getPagina();
        String other$pagina = other.getPagina();
        if (this$pagina == null ? other$pagina != null : !this$pagina.equals(other$pagina)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        String this$nomeArquivo = this.getNomeArquivo();
        String other$nomeArquivo = other.getNomeArquivo();
        return !(this$nomeArquivo == null ? other$nomeArquivo != null : !this$nomeArquivo.equals(other$nomeArquivo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VeiculoPublicacaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $numeroEdicao = this.getNumeroEdicao();
        result = result * 59 + ($numeroEdicao == null ? 43 : ((Object)$numeroEdicao).hashCode());
        Long $anoEdicao = this.getAnoEdicao();
        result = result * 59 + ($anoEdicao == null ? 43 : ((Object)$anoEdicao).hashCode());
        Long $idArquivo = this.getIdArquivo();
        result = result * 59 + ($idArquivo == null ? 43 : ((Object)$idArquivo).hashCode());
        String $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : $codigo.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        LocalDate $dataPublicacao = this.getDataPublicacao();
        result = result * 59 + ($dataPublicacao == null ? 43 : ((Object)$dataPublicacao).hashCode());
        String $pagina = this.getPagina();
        result = result * 59 + ($pagina == null ? 43 : $pagina.hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        String $nomeArquivo = this.getNomeArquivo();
        result = result * 59 + ($nomeArquivo == null ? 43 : $nomeArquivo.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "VeiculoPublicacaoDTO(id=" + this.getId() + ", codigo=" + this.getCodigo() + ", nome=" + this.getNome() + ", dataPublicacao=" + this.getDataPublicacao() + ", pagina=" + this.getPagina() + ", numeroEdicao=" + this.getNumeroEdicao() + ", anoEdicao=" + this.getAnoEdicao() + ", descricao=" + this.getDescricao() + ", idArquivo=" + this.getIdArquivo() + ", nomeArquivo=" + this.getNomeArquivo() + ")";
    }

    @Generated
    public VeiculoPublicacaoDTO() {
    }

    @Generated
    public VeiculoPublicacaoDTO(Long id, String codigo, String nome, LocalDate dataPublicacao, String pagina, Long numeroEdicao, Long anoEdicao, String descricao, Long idArquivo, String nomeArquivo) {
        this.id = id;
        this.codigo = codigo;
        this.nome = nome;
        this.dataPublicacao = dataPublicacao;
        this.pagina = pagina;
        this.numeroEdicao = numeroEdicao;
        this.anoEdicao = anoEdicao;
        this.descricao = descricao;
        this.idArquivo = idArquivo;
        this.nomeArquivo = nomeArquivo;
    }
}

