/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.ContrapartidaDTO;
import br.com.elotech.contabilidade.client.dto.ConvenioSaldoDTO;
import br.com.elotech.core.utils.NumberUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;

public class RepasseConvenioDTO {
    private BigDecimal valor;
    private LocalDate data;
    private Long tipo;

    public BigDecimal getValor() {
        if (Objects.nonNull(this.valor)) {
            return NumberUtils.formatBigDecimal((BigDecimal)this.valor);
        }
        return null;
    }

    public static RepasseConvenioDTO ofContraPartida(ContrapartidaDTO contrapartida) {
        return new RepasseConvenioDTO(contrapartida.getValor(), contrapartida.getDataLancamento(), contrapartida.getTipoContrapartida().getCodigo());
    }

    public static RepasseConvenioDTO ofConvenioSaldo(ConvenioSaldoDTO convenioSaldo) {
        return new RepasseConvenioDTO(convenioSaldo.getValor(), convenioSaldo.getData(), convenioSaldo.getTipoMovimentoValor().getCodigo());
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public Long getTipo() {
        return this.tipo;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setTipo(Long tipo) {
        this.tipo = tipo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepasseConvenioDTO)) {
            return false;
        }
        RepasseConvenioDTO other = (RepasseConvenioDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tipo = this.getTipo();
        Long other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !((Object)this$tipo).equals(other$tipo)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RepasseConvenioDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : ((Object)$tipo).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RepasseConvenioDTO(valor=" + this.getValor() + ", data=" + this.getData() + ", tipo=" + this.getTipo() + ")";
    }

    @Generated
    public RepasseConvenioDTO(BigDecimal valor, LocalDate data, Long tipo) {
        this.valor = valor;
        this.data = data;
        this.tipo = tipo;
    }

    @Generated
    public RepasseConvenioDTO() {
    }
}

