/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.CreditoAdicionalDotacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.CreditosAdicionaisDTO;
import java.math.BigDecimal;
import lombok.Generated;

public class CreditosAdicionaisDTO {
    public static final String SUPLEMENTAR = "S";
    private Long entidade;
    private Long exercicio;
    private String despesa;
    private BigDecimal valorInicial;
    private BigDecimal valor;
    private String decreto;
    private String natureza;
    private BigDecimal saldoAtualizado;
    private Long sequencia;
    private Long fonteRecurso;
    private Long idDecreto;

    public static CreditosAdicionaisDTO ofDTOContabil(CreditoAdicionalDotacaoDTO dto) {
        CreditosAdicionaisDTO credito = new CreditosAdicionaisDTO();
        credito.setDespesa(dto.getDotacao().getCodigoFormatted());
        credito.setValorInicial(dto.getValor());
        credito.setDecreto(dto.getDecreto());
        credito.setNatureza(dto.getOperacao().getDescricao());
        credito.setSequencia(dto.getSequencia());
        credito.setFonteRecurso(Long.valueOf(dto.getFonteRecurso().getCodigo()));
        credito.setSaldoAtualizado(dto.getAtualizado());
        if (SUPLEMENTAR.equals(dto.getOperacao().getCodigo())) {
            credito.setValor(dto.getAtualizado().subtract(dto.getValor()));
        } else {
            credito.setValor(dto.getAtualizado().add(dto.getValor()));
        }
        return credito;
    }

    @Generated
    public static CreditosAdicionaisDTOBuilder builder() {
        return new CreditosAdicionaisDTOBuilder();
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getDespesa() {
        return this.despesa;
    }

    @Generated
    public BigDecimal getValorInicial() {
        return this.valorInicial;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public String getDecreto() {
        return this.decreto;
    }

    @Generated
    public String getNatureza() {
        return this.natureza;
    }

    @Generated
    public BigDecimal getSaldoAtualizado() {
        return this.saldoAtualizado;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public Long getFonteRecurso() {
        return this.fonteRecurso;
    }

    @Generated
    public Long getIdDecreto() {
        return this.idDecreto;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDespesa(String despesa) {
        this.despesa = despesa;
    }

    @Generated
    public void setValorInicial(BigDecimal valorInicial) {
        this.valorInicial = valorInicial;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setDecreto(String decreto) {
        this.decreto = decreto;
    }

    @Generated
    public void setNatureza(String natureza) {
        this.natureza = natureza;
    }

    @Generated
    public void setSaldoAtualizado(BigDecimal saldoAtualizado) {
        this.saldoAtualizado = saldoAtualizado;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setFonteRecurso(Long fonteRecurso) {
        this.fonteRecurso = fonteRecurso;
    }

    @Generated
    public void setIdDecreto(Long idDecreto) {
        this.idDecreto = idDecreto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreditosAdicionaisDTO)) {
            return false;
        }
        CreditosAdicionaisDTO other = (CreditosAdicionaisDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        Long this$fonteRecurso = this.getFonteRecurso();
        Long other$fonteRecurso = other.getFonteRecurso();
        if (this$fonteRecurso == null ? other$fonteRecurso != null : !((Object)this$fonteRecurso).equals(other$fonteRecurso)) {
            return false;
        }
        Long this$idDecreto = this.getIdDecreto();
        Long other$idDecreto = other.getIdDecreto();
        if (this$idDecreto == null ? other$idDecreto != null : !((Object)this$idDecreto).equals(other$idDecreto)) {
            return false;
        }
        String this$despesa = this.getDespesa();
        String other$despesa = other.getDespesa();
        if (this$despesa == null ? other$despesa != null : !this$despesa.equals(other$despesa)) {
            return false;
        }
        BigDecimal this$valorInicial = this.getValorInicial();
        BigDecimal other$valorInicial = other.getValorInicial();
        if (this$valorInicial == null ? other$valorInicial != null : !((Object)this$valorInicial).equals(other$valorInicial)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        String this$decreto = this.getDecreto();
        String other$decreto = other.getDecreto();
        if (this$decreto == null ? other$decreto != null : !this$decreto.equals(other$decreto)) {
            return false;
        }
        String this$natureza = this.getNatureza();
        String other$natureza = other.getNatureza();
        if (this$natureza == null ? other$natureza != null : !this$natureza.equals(other$natureza)) {
            return false;
        }
        BigDecimal this$saldoAtualizado = this.getSaldoAtualizado();
        BigDecimal other$saldoAtualizado = other.getSaldoAtualizado();
        return !(this$saldoAtualizado == null ? other$saldoAtualizado != null : !((Object)this$saldoAtualizado).equals(other$saldoAtualizado));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreditosAdicionaisDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        Long $fonteRecurso = this.getFonteRecurso();
        result = result * 59 + ($fonteRecurso == null ? 43 : ((Object)$fonteRecurso).hashCode());
        Long $idDecreto = this.getIdDecreto();
        result = result * 59 + ($idDecreto == null ? 43 : ((Object)$idDecreto).hashCode());
        String $despesa = this.getDespesa();
        result = result * 59 + ($despesa == null ? 43 : $despesa.hashCode());
        BigDecimal $valorInicial = this.getValorInicial();
        result = result * 59 + ($valorInicial == null ? 43 : ((Object)$valorInicial).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        String $decreto = this.getDecreto();
        result = result * 59 + ($decreto == null ? 43 : $decreto.hashCode());
        String $natureza = this.getNatureza();
        result = result * 59 + ($natureza == null ? 43 : $natureza.hashCode());
        BigDecimal $saldoAtualizado = this.getSaldoAtualizado();
        result = result * 59 + ($saldoAtualizado == null ? 43 : ((Object)$saldoAtualizado).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CreditosAdicionaisDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", despesa=" + this.getDespesa() + ", valorInicial=" + this.getValorInicial() + ", valor=" + this.getValor() + ", decreto=" + this.getDecreto() + ", natureza=" + this.getNatureza() + ", saldoAtualizado=" + this.getSaldoAtualizado() + ", sequencia=" + this.getSequencia() + ", fonteRecurso=" + this.getFonteRecurso() + ", idDecreto=" + this.getIdDecreto() + ")";
    }

    @Generated
    public CreditosAdicionaisDTO() {
    }

    @Generated
    public CreditosAdicionaisDTO(Long entidade, Long exercicio, String despesa, BigDecimal valorInicial, BigDecimal valor, String decreto, String natureza, BigDecimal saldoAtualizado, Long sequencia, Long fonteRecurso, Long idDecreto) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.despesa = despesa;
        this.valorInicial = valorInicial;
        this.valor = valor;
        this.decreto = decreto;
        this.natureza = natureza;
        this.saldoAtualizado = saldoAtualizado;
        this.sequencia = sequencia;
        this.fonteRecurso = fonteRecurso;
        this.idDecreto = idDecreto;
    }
}

