/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioBemArquivoPK;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="siscop.PAT_BEMARQUIVOS")
public class PatrimonioBemArquivo
implements EloEntity<PatrimonioBemArquivoPK> {
    @EmbeddedId
    private PatrimonioBemArquivoPK id;
    @Length(max=60)
    @Column(name="descricao")
    private @Length(max=60) String nomeArquivo;
    @Length(max=1)
    private @Length(max=1) String extensao;
    @Column(name="idBem")
    private Long idArquivo;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean sigiloso = Boolean.FALSE;

    public static Boolean arquivosNaoSigilosos(PatrimonioBemArquivo patrimonioBemArquivo) {
        return Objects.nonNull(patrimonioBemArquivo) && Boolean.FALSE.equals(patrimonioBemArquivo.getSigiloso());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatrimonioBemArquivo)) {
            return false;
        }
        PatrimonioBemArquivo other = (PatrimonioBemArquivo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PatrimonioBemArquivoPK this$id = this.getId();
        PatrimonioBemArquivoPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PatrimonioBemArquivo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PatrimonioBemArquivoPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public PatrimonioBemArquivo() {
    }

    @Generated
    public PatrimonioBemArquivoPK getId() {
        return this.id;
    }

    @Generated
    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    @Generated
    public String getExtensao() {
        return this.extensao;
    }

    @Generated
    public Long getIdArquivo() {
        return this.idArquivo;
    }

    @Generated
    public Boolean getSigiloso() {
        return this.sigiloso;
    }

    @Generated
    public void setId(PatrimonioBemArquivoPK id) {
        this.id = id;
    }

    @Generated
    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    @Generated
    public void setExtensao(String extensao) {
        this.extensao = extensao;
    }

    @Generated
    public void setIdArquivo(Long idArquivo) {
        this.idArquivo = idArquivo;
    }

    @Generated
    public void setSigiloso(Boolean sigiloso) {
        this.sigiloso = sigiloso;
    }

    @Generated
    public String toString() {
        return "PatrimonioBemArquivo(id=" + this.getId() + ", nomeArquivo=" + this.getNomeArquivo() + ", extensao=" + this.getExtensao() + ", idArquivo=" + this.getIdArquivo() + ", sigiloso=" + this.getSigiloso() + ")";
    }
}

