/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource.params;

import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindPcaParams;
import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FindPcaParams {
    private Long entidade;
    private Long exercicio;
    private Long planoContratacao;
    private String dataPca;
    private String exportType;

    public String montaWhere() {
        StringBuilder where = new StringBuilder();
        if (Objects.nonNull(this.entidade)) {
            where.append("\n AND P.ENTIDADE = :entidade");
        }
        if (Objects.nonNull(this.exercicio)) {
            where.append("\n AND P.EXERCICIO = :exercicio");
        }
        if (Objects.nonNull(this.planoContratacao)) {
            where.append("\n AND P.PLANOCONTRATACAO = :planoContratacao");
        }
        if (Objects.nonNull(this.dataPca)) {
            where.append("\n AND CAST(P.DATAPCA AS DATE) = :dataPca");
        }
        return where.toString();
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addExercicio(params);
        this.addPlanoContratacao(params);
        this.addDataPca(params);
        return params;
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addExercicio(MapSqlParameterSource params) {
        params.addValue("exercicio", (Object)this.exercicio, 2);
    }

    private void addPlanoContratacao(MapSqlParameterSource params) {
        params.addValue("planoContratacao", (Object)this.planoContratacao, 2);
    }

    private void addDataPca(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataPca)) {
            params.addValue("dataPca", (Object)this.dataPca, 91);
        }
    }

    @Generated
    public static FindPcaParamsBuilder builder() {
        return new FindPcaParamsBuilder();
    }

    @Generated
    public FindPcaParams(Long entidade, Long exercicio, Long planoContratacao, String dataPca, String exportType) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.planoContratacao = planoContratacao;
        this.dataPca = dataPca;
        this.exportType = exportType;
    }

    @Generated
    public FindPcaParams() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getPlanoContratacao() {
        return this.planoContratacao;
    }

    @Generated
    public String getDataPca() {
        return this.dataPca;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setPlanoContratacao(Long planoContratacao) {
        this.planoContratacao = planoContratacao;
    }

    @Generated
    public void setDataPca(String dataPca) {
        this.dataPca = dataPca;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindPcaParams)) {
            return false;
        }
        FindPcaParams other = (FindPcaParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$planoContratacao = this.getPlanoContratacao();
        Long other$planoContratacao = other.getPlanoContratacao();
        if (this$planoContratacao == null ? other$planoContratacao != null : !((Object)this$planoContratacao).equals(other$planoContratacao)) {
            return false;
        }
        String this$dataPca = this.getDataPca();
        String other$dataPca = other.getDataPca();
        if (this$dataPca == null ? other$dataPca != null : !this$dataPca.equals(other$dataPca)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        return !(this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindPcaParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $planoContratacao = this.getPlanoContratacao();
        result = result * 59 + ($planoContratacao == null ? 43 : ((Object)$planoContratacao).hashCode());
        String $dataPca = this.getDataPca();
        result = result * 59 + ($dataPca == null ? 43 : $dataPca.hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FindPcaParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", planoContratacao=" + this.getPlanoContratacao() + ", dataPca=" + this.getDataPca() + ", exportType=" + this.getExportType() + ")";
    }
}

