/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import br.com.elotech.portaltransparencia.comprasportal.domain.AdjudicacaoArquivo;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AdjudicacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.AdjudicacaoArquivoRepository;
import br.com.elotech.portaltransparencia.comprasportal.repository.AdjudicacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindAdjudicacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class AdjudicacaoRepositoryImpl
implements AdjudicacaoRepository {
    private static final String ADJUDICACAO = "db/sql/compras/adjudicacao.sql";
    private static final String ADJUDICACOES = "db/sql/compras/adjudicacoes.sql";
    private final DatasourceWrapper datasourceWrapper;
    private final AdjudicacaoArquivoRepository adjudicacaoArquivoRepository;
    private final EloArquivoRepository eloArquivoRepository;

    @Autowired
    public AdjudicacaoRepositoryImpl(DatasourceWrapper datasourceWrapper, AdjudicacaoArquivoRepository adjudicacaoArquivoRepository, EloArquivoRepository eloArquivoRepository) {
        this.datasourceWrapper = datasourceWrapper;
        this.adjudicacaoArquivoRepository = adjudicacaoArquivoRepository;
        this.eloArquivoRepository = eloArquivoRepository;
    }

    public AdjudicacaoLicitacaoDTO findAdjudicacao(FindAdjudicacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)ADJUDICACAO).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        return (AdjudicacaoLicitacaoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AdjudicacaoLicitacaoDTO.class));
    }

    public List<AdjudicacaoLicitacaoDTO> findAdjudicacoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)ADJUDICACOES).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AdjudicacaoLicitacaoDTO.class));
    }

    public List<AdjudicacaoArquivo> findArquivos(FindAdjudicacaoParams params, String nomeSchemaEloArquivo) {
        List adjudicacaoArquivos = this.adjudicacaoArquivoRepository.findByEntidadeAndExercicioAndExercicioLicitacaoAndTipoLicitacaoAndLicitacaoAndPessoa((Long)params.getEntidade().get(), (Long)params.getExercicio().get(), (Long)params.getExercicioLicitacao().get(), (Long)params.getTipoLicitacao().get(), (Long)params.getLicitacao().get(), (Long)params.getPessoa().get());
        adjudicacaoArquivos.stream().filter(AdjudicacaoArquivo::possuiEloArquivo).map(AdjudicacaoArquivo::getArquivoCompras).forEach(a -> a.setTamanhoArquivo(this.eloArquivoRepository.getTamanhoArquivo(a.getArquivo().getId())));
        return adjudicacaoArquivos;
    }
}

