/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.portaltransparencia.aiseportal.domain.dto.CedidoDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.CedidoRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindCedidoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.CedidoService;
import br.com.elotech.portaltransparencia.aiseportal.service.IntegracaoAiseOxyFolhaPagamentoService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.folhaportal.service.CedidoServiceOxy;
import br.com.elotech.reportexport.exporter.BaseExport;
import java.util.Objects;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class CedidoServiceImpl
implements CedidoService {
    private final CedidoRepository repository;
    private final CedidoServiceOxy serviceOxy;
    private final IntegracaoAiseOxyFolhaPagamentoService integracaoAiseOxyService;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final BaseExport baseExport;

    public Page<CedidoDTO> findCedidos(FindCedidoParams params, Pageable pageable) {
        if (this.integracaoAiseOxyService.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return this.serviceOxy.findCedidos(params, pageable);
        }
        return this.repository.findCedidos(params, pageable);
    }

    public String findNomeEntidadeById(Long entidadeId) {
        Entidade entidade = (Entidade)this.entidadeRepository.findOne((Object)entidadeId);
        return Objects.nonNull(entidade) ? entidade.getNome() : "";
    }

    @Generated
    public CedidoServiceImpl(CedidoRepository repository, CedidoServiceOxy serviceOxy, IntegracaoAiseOxyFolhaPagamentoService integracaoAiseOxyService, EntidadeContabilidadeRepository entidadeRepository, BaseExport baseExport) {
        this.repository = repository;
        this.serviceOxy = serviceOxy;
        this.integracaoAiseOxyService = integracaoAiseOxyService;
        this.entidadeRepository = entidadeRepository;
        this.baseExport = baseExport;
    }

    @Generated
    public BaseExport getBaseExport() {
        return this.baseExport;
    }
}

