/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PensionistaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.service.PensionistaService;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pensionistas"})
public class PensionistaResource {
    private final PensionistaService pensionistaService;

    @Autowired
    public PensionistaResource(PensionistaService pensionistaService) {
        this.pensionistaService = pensionistaService;
    }

    @GetMapping(value={"/{codigo}"})
    public ResponseEntity<PensionistaDTO> getPensionista(@PathVariable Long codigo, @RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setCodigo(codigo);
        Optional servidor = this.pensionistaService.loadPensionista(servidorParams);
        return servidor.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping
    public ResponseEntity<Page<PensionistaDTO>> loadPensionistas(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams pensionistasParams, Pageable pageable) {
        pensionistasParams.setEntidade(entidade);
        pensionistasParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.pensionistaService.loadPensionistas(pensionistasParams, pageable));
    }

    @GetMapping(value={"/{vinculo}/{codigo}"})
    public ResponseEntity<PensionistaDTO> getPensionistaPorVinculo(@PathVariable String vinculo, @PathVariable Long codigo, @RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setMatricula(codigo);
        servidorParams.setVinculo(vinculo);
        Optional servidor = this.pensionistaService.loadPensionista(servidorParams);
        return servidor.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/vencimentos-descontos"}, params={"matricula", "anoCompetencia", "mesCompetencia", "tipoEvento", "tipoFolha", "codigoCalculo", "entidadeOrigem"})
    public ResponseEntity<List<ServidorVencimentosDescontosDTO>> loadVencimentosEDescontosPensionista(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidadeAise(entidade);
        servidorParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.pensionistaService.loadVencimentoEDescontos(servidorParams));
    }
}

