/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.admportal.domain.EmendaParlamentar;
import br.com.elotech.portaltransparencia.admportal.repository.EmendaParlamentarRepositoryCustom;
import br.com.elotech.portaltransparencia.admportal.resource.params.EmendaParlamentarParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class EmendaParlamentarRepositoryImpl
implements EmendaParlamentarRepositoryCustom {
    private static final String SQL_EMENDA_PARLAMENTAR = "db/sql/contab/emenda-parlamentar.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public EmendaParlamentarRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<EmendaParlamentar> findByParams(EmendaParlamentarParams params, Pageable pageable) {
        String filtro = this.getFiltros(params);
        String sql = FileUtils.readResourceAsString((String)SQL_EMENDA_PARLAMENTAR) + filtro;
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)" ORDER BY E.ID DESC ");
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        List emendas = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmendaParlamentar.class));
        return new PageImpl(emendas, pageable, this.getQuantidadeEmendas(sql.toString(), params.toJdbcParameter()).longValue());
    }

    private String getFiltros(EmendaParlamentarParams params) {
        StringBuilder filtro = new StringBuilder();
        filtro.append(" WHERE 1 = 1 ");
        params.getId().ifPresent(i -> filtro.append(" AND E.ID = ").append(params.getId().get()));
        params.getEntidade().ifPresent(i -> filtro.append(" AND E.ENTIDADE = ").append(params.getEntidade().get()));
        params.getExercicio().ifPresent(i -> filtro.append(" AND E.EXERCICIO = ").append(params.getExercicio().get()));
        params.getNumero().ifPresent(i -> filtro.append(" AND E.NUMERO = ").append(params.getNumero().get()));
        params.getAutoria().ifPresent(i -> filtro.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(E.AUTORIA)) LIKE ${db.contabilidade.schema}.tiraacento(LOWER('%").append((String)params.getAutoria().get()).append("%')) "));
        params.getTipo().ifPresent(i -> filtro.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(E.TIPO)) LIKE ${db.contabilidade.schema}.tiraacento(LOWER('%").append((String)params.getTipo().get()).append("%')) "));
        params.getFuncao().ifPresent(i -> filtro.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(E.FUNCAO)) LIKE ${db.contabilidade.schema}.tiraacento(LOWER('%").append((String)params.getFuncao().get()).append("%')) "));
        params.getObjeto().ifPresent(i -> filtro.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(E.OBJETO)) LIKE ${db.contabilidade.schema}.tiraacento(LOWER('%").append((String)params.getObjeto().get()).append("%')) "));
        return filtro.toString();
    }

    private Long getQuantidadeEmendas(String query, MapSqlParameterSource parameter) {
        StringBuilder queryCount = new StringBuilder("SELECT COUNT(*) FROM (");
        queryCount.append(query);
        queryCount.append(") COUNT");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)parameter, Long.class);
    }
}

