/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.contabilidade.client.InterferenciaFinanceiraFeignClient;
import br.com.elotech.contabilidade.client.dto.DemonstrativoInterferenciaFinanceiraDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseMesDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindRepasseParams;
import br.com.elotech.portaltransparencia.contabportal.service.RepasseService;
import br.com.elotech.portaltransparencia.utils.PrecisionUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class RepasseOxyServiceImpl
implements RepasseService {
    private final InterferenciaFinanceiraFeignClient feignClient;

    public List<RepasseDTO> findRepasses(FindRepasseParams params) {
        return this.feignClient.findDemonstrativoByEntidadesAndDataBetween(params.getEntidade().toString(), params.getDataInicial().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 1, 1)), params.getDataFinal().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 12, 31))).stream().filter(item -> this.filterDemonstrativo(params.getTipo(), item)).map(item -> RepasseDTO.ofDemonstrativo((DemonstrativoInterferenciaFinanceiraDTO)item, (String)params.getTipo())).collect(Collectors.toList());
    }

    public List<RepasseMesDTO> findRepassesEnviadosMes(FindRepasseParams params) {
        return this.feignClient.findDetalheByExtraOrcamentarioAndEntidadesAndDataBetween(String.valueOf(params.getIdContaCorrente().orElse(0L)), params.getEntidade().toString(), params.getDataInicial().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 1, 1)), params.getDataFinal().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 12, 31))).stream().filter(item -> this.filterDemonstrativo(params.getTipo(), item)).map(item -> RepasseMesDTO.ofDemonstrativo((DemonstrativoInterferenciaFinanceiraDTO)item, (String)params.getTipo())).collect(Collectors.toList());
    }

    public List<RepasseMesDTO> findRepassesRecebidosMes(FindRepasseParams params) {
        return this.feignClient.findDetalheByExtraOrcamentarioAndEntidadesAndDataBetween(String.valueOf(params.getIdContaCorrente().orElse(0L)), params.getEntidade().toString(), params.getDataInicial().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 1, 1)), params.getDataFinal().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 12, 31))).stream().filter(item -> this.filterDemonstrativo(params.getTipo(), item)).map(item -> RepasseMesDTO.ofDemonstrativo((DemonstrativoInterferenciaFinanceiraDTO)item, (String)params.getTipo())).collect(Collectors.toList());
    }

    private boolean filterDemonstrativo(String tipo, DemonstrativoInterferenciaFinanceiraDTO item) {
        return tipo.equals("R") && PrecisionUtils.isDifferentFromZero((BigDecimal)item.getIngresso()) != false || tipo.equals("E") && PrecisionUtils.isDifferentFromZero((BigDecimal)item.getEgresso()) != false;
    }

    @Generated
    public RepasseOxyServiceImpl(InterferenciaFinanceiraFeignClient feignClient) {
        this.feignClient = feignClient;
    }
}

