SELECT A.CENTROCUSTO,
       C.DESCRICAO CENTROCUSTODESCRICAO,
       CAST(B.ITEM AS DOUBLE PRECISION) ITEM,
       D.DESCRICAO ITEMDESCRICAO,
       D.UNIDADE,
       COALESCE(SUM(CASE WHEN A.SINAL = '+' THEN B.QUANTIDADE ELSE B.QUANTIDADE* -1 END),0) SALDO,
       COALESCE(SUM(CASE WHEN A.SINAL = '+' THEN B.VALORTOTAL ELSE B.VALORTOTAL* -1 END),0) VALORTOTAL,
       COALESCE(SUM(CASE WHEN A.SINAL = '+' THEN B.VALORTOTAL ELSE B.VALORTOTAL* -1 END),0) / COALESCE(SUM(CASE WHEN A.SINAL = '+' THEN B.QUANTIDADE ELSE B.QUANTIDADE* -1 END),0) CUSTOUNITARIO
  FROM ${db.contabilidade.schema}.EST_MOVIMENTACAO A
 INNER JOIN ${db.contabilidade.schema}.EST_MOVIMENTACAO_ITENS B
    ON A.ENTIDADE = B.ENTIDADE
   AND A.EXERCICIO = B.EXERCICIO
   AND A.NUMERO = B.NUMERO
   AND A.SEQUENCIA = B.SEQUENCIA
 INNER JOIN ${db.contabilidade.schema}.EST_CENTROCUSTO C
    ON A.ENTIDADE = C.ENTIDADE
   AND A.CENTROCUSTO = C.CENTROCUSTO
 INNER JOIN ${db.contabilidade.schema}.EST_ITEM D
    ON B.ITEM = D.ITEM
 WHERE A.ENTIDADE = :entidade
   AND A.SALDOATUALIZADO = 'S'
   AND (:centroCusto = -99 OR A.CENTROCUSTO = :centroCusto)
   AND C.ATIVOINATIVOAI <> 'I'
   AND A.DATA <= :data
   AND (:orgao = 'TODOS' OR C.ORGAO = :orgao)
   AND (:itemDescricao = '%TODOS%' OR ${db.contabilidade.schema}.tiraacento(UPPER(D.DESCRICAO)) LIKE ${db.contabilidade.schema}.tiraacento(:itemDescricao))
 GROUP BY A.CENTROCUSTO, C.DESCRICAO, B.ITEM, D.UNIDADE, D.DESCRICAO
HAVING COALESCE(SUM(CASE WHEN A.SINAL = '+' THEN B.QUANTIDADE ELSE B.QUANTIDADE* -1 END),0) > 0

