SELECT A.DATA,
	   LENGTH(AC.ARQUIVO) AS TAMANHOARQUIVO,
       D.IDARQUIVO,
       case when D.NOMEARQUIVO is null then eloarq.nome else D.NOMEARQUIVO end as nomearquivo,
       D.DATA AS DATAARQUIVO,
       C.NOME RESPONSAVEL,
       A.SEQUENCIA,
       CASE WHEN A.TIPO = 'JE' THEN 'JURÍDICO EDITAL'
         WHEN A.TIPO = 'JJ' THEN 'JURÍDICO JULGAMENTO'
         WHEN A.TIPO = 'JI' THEN 'JURÍDICO INEXIGIBILIDADE'
         WHEN A.TIPO = 'JD' THEN 'JURÍDICO DISPENSA'
         WHEN A.TIPO = 'JO' THEN 'JURÍDICO OUTROS'
         WHEN A.TIPO = 'T' THEN 'TÉCNICO'
         WHEN A.TIPO = 'AB' THEN 'ABERTURA'
       END TIPOPARECER
  FROM ${db.compras.schema}.CLPARECER A
 INNER JOIN ${db.compras.schema}.CLLICITACAO B
    ON  B.ENTIDADE = A.ENTIDADE
   AND B.EXERCICIO = A.EXERCICIOLICITACAO
   AND B.TIPOLICITACAO = A.TIPOLICITACAO
   AND B.LICITACAO = A.LICITACAO
 INNER JOIN ${db.compras.schema}.CLMEMBRO C
    ON  C.MEMBRO = A.MEMBRO
  LEFT OUTER JOIN ${db.compras.schema}.ARQUIVO D
    ON  D.ID = A.IDARQUIVO
   AND COALESCE(D.ARQUIVOSIGILOSO,'N') <> 'S'
  LEFT OUTER JOIN schema_eloarquivo.ARQUIVO eloarq
    ON  eloarq.ID = D.IDARQUIVO
  LEFT OUTER JOIN schema_eloarquivo.ARQUIVO_CONTENT AC
    ON  AC.ID = D.IDARQUIVO
 WHERE B.ENTIDADE = :entidade 
   AND B.EXERCICIO = :exercicio 
   AND B.TIPOLICITACAO = :tipoLicitacao 
   AND B.LICITACAO = :licitacao 
 ORDER BY A.SEQUENCIA