/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.contabilidade.client.DiariaFeignClient;
import br.com.elotech.contabilidade.client.enums.TipoRetorno;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AdiantamentoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import br.com.elotech.portaltransparencia.contabportal.service.AdiantamentoService;
import br.com.elotech.portaltransparencia.contabportal.utils.DiariaOxyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class AdiantamentoOxyService
implements AdiantamentoService {
    private final DiariaFeignClient diariaFeignClient;
    private static final String ADIANTAMENTO = "2";

    public Page<AdiantamentoPessoalDTO> findAdiantamentos(FindPessoalParams findPessoalParams, Pageable pageable) {
        EloPage adiantamentos = this.diariaFeignClient.encontrarEmpenhoAdiantamentoPortal(DiariaOxyUtils.buildSearch((FindPessoalParams)findPessoalParams, (String)";", (String)ADIANTAMENTO), pageable);
        ArrayList adiantamentoPessoal = new ArrayList();
        adiantamentos.getContent().forEach(adiantamento -> adiantamentoPessoal.add(new AdiantamentoPessoalDTO(adiantamento)));
        return new PageImpl(adiantamentoPessoal, pageable, adiantamentos.getTotalElements());
    }

    public AdiantamentoPessoalDTO findTotalAdiantamentos(FindPessoalParams findPessoalParams) {
        return new AdiantamentoPessoalDTO();
    }

    public Optional<AdiantamentoPessoalDTO> findAdiantamento(FindPessoalParams findPessoalParams) {
        return this.diariaFeignClient.encontrarEmpenhoAdiantamentoPortal(this.buildSearchAdiantamento(findPessoalParams), (Pageable)PageRequest.of((int)0, (int)1)).getContent().stream().findFirst().map(AdiantamentoPessoalDTO::new);
    }

    private String buildSearchAdiantamento(FindPessoalParams findPessoalParams) {
        return String.format("numeroEmpenho==%s;tipoRetorno==%s", findPessoalParams.getEmpenho(), this.getTipoRetornoAdiantamento(findPessoalParams.getIsReembolso()));
    }

    private String getTipoRetornoAdiantamento(Boolean isReembolso) {
        if (Objects.nonNull(isReembolso) && isReembolso.booleanValue()) {
            return TipoRetorno.EMPENHO_REEMBOLSO.getValue();
        }
        return TipoRetorno.ADIANTAMENTO.getValue();
    }

    public Optional<AdiantamentoPessoalDTO> findPrestacaoContas(FindPessoalParams findPessoalParams) {
        return Optional.empty();
    }

    public List<ArquivoPessoalDTO> findArquivos(FindPessoalParams findPessoalParams) {
        return new ArrayList<ArquivoPessoalDTO>();
    }

    @Generated
    public AdiantamentoOxyService(DiariaFeignClient diariaFeignClient) {
        this.diariaFeignClient = diariaFeignClient;
    }
}

