/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.patrimonio.client.MovimentacaoGaragemClient;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.MovimentoGaragemDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.MovimentoGaragemRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.MovimentoGaragemParams;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class MovimentoGaragemRepositoryOxyImpl
implements MovimentoGaragemRepository {
    private final MovimentacaoGaragemClient client;

    public MovimentoGaragemRepositoryOxyImpl(MovimentacaoGaragemClient client) {
        this.client = client;
    }

    public Page<MovimentoGaragemDTO> findMovimentosGaragem(MovimentoGaragemParams params, Pageable pageable) {
        if (params == null) {
            params = new MovimentoGaragemParams();
        }
        EloPage oxyPage = this.client.findMovimentosGaragem(params.toOxyObject(), pageable);
        List content = oxyPage.getContent().stream().map(MovimentoGaragemDTO::fromOxyObject).collect(Collectors.toList());
        return new PageImpl(content, pageable, oxyPage.getTotalElements());
    }

    public Optional<MovimentoGaragemDTO> findMovimentoGaragem(MovimentoGaragemParams params) {
        if (params == null) {
            params = new MovimentoGaragemParams();
        }
        Optional oxyObject = this.client.findMovimentoGaragem(params.toOxyObject());
        MovimentoGaragemDTO movimentoGaragem = oxyObject.map(MovimentoGaragemDTO::fromOxyObject).orElse(new MovimentoGaragemDTO());
        return Optional.of(movimentoGaragem);
    }
}

