/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource.params;

import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class AudienciasPublicasParams {
    private Long entidade;
    private Long exercicio;
    private String natureza;
    private String tipo;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataInicial;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataFinal;
    private Long id;
    private String exportType;

    public String montaFiltro() {
        StringBuilder where = new StringBuilder();
        if (Objects.nonNull(this.dataInicial)) {
            where.append(" AND DATA >= :dataInicial");
        }
        if (Objects.nonNull(this.dataFinal)) {
            where.append(" AND DATA <= :dataFinal");
        }
        if (Objects.nonNull(this.natureza)) {
            where.append(" AND ${db.contabilidade.schema}.tiraacento(UPPER(NATUREZAAUDIENCIA.DESCRICAO)) LIKE ${db.contabilidade.schema}.tiraacento(UPPER(:natureza))");
        }
        if (Objects.nonNull(this.tipo)) {
            where.append(" AND ${db.contabilidade.schema}.tiraacento(UPPER(TIPOAUDIENCIA.DESCRICAO)) LIKE ${db.contabilidade.schema}.tiraacento(UPPER(:tipo))");
        }
        return where.toString();
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
        if (Objects.nonNull(this.id)) {
            params.addValue("id", (Object)this.id, 2);
        }
        if (Objects.nonNull(this.dataInicial)) {
            params.addValue("dataInicial", (Object)Date.valueOf(this.dataInicial), 91);
        }
        if (Objects.nonNull(this.dataFinal)) {
            params.addValue("dataFinal", (Object)Date.valueOf(this.dataFinal), 91);
        }
        if (Objects.nonNull(this.natureza)) {
            params.addValue("natureza", (Object)SqlUtils.toSqlLike((String)this.natureza), 12);
        }
        if (Objects.nonNull(this.tipo)) {
            params.addValue("tipo", (Object)SqlUtils.toSqlLike((String)this.tipo), 12);
        }
        return params;
    }

    public String toFiltroOxy() {
        ArrayList<String> filtros = new ArrayList<String>();
        if (Objects.nonNull(this.id)) {
            filtros.add(String.format("id == %s", this.id));
        }
        if (Objects.nonNull(this.dataInicial)) {
            filtros.add(String.format("data >= '%s'", this.dataInicial));
        }
        if (Objects.nonNull(this.dataFinal)) {
            filtros.add(String.format("data <= '%s'", this.dataFinal));
        }
        return String.join((CharSequence)" and ", filtros);
    }

    @Generated
    public AudienciasPublicasParams() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getNatureza() {
        return this.natureza;
    }

    @Generated
    public String getTipo() {
        return this.tipo;
    }

    @Generated
    public LocalDate getDataInicial() {
        return this.dataInicial;
    }

    @Generated
    public LocalDate getDataFinal() {
        return this.dataFinal;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setNatureza(String natureza) {
        this.natureza = natureza;
    }

    @Generated
    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudienciasPublicasParams)) {
            return false;
        }
        AudienciasPublicasParams other = (AudienciasPublicasParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$natureza = this.getNatureza();
        String other$natureza = other.getNatureza();
        if (this$natureza == null ? other$natureza != null : !this$natureza.equals(other$natureza)) {
            return false;
        }
        String this$tipo = this.getTipo();
        String other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        LocalDate this$dataInicial = this.getDataInicial();
        LocalDate other$dataInicial = other.getDataInicial();
        if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
            return false;
        }
        LocalDate this$dataFinal = this.getDataFinal();
        LocalDate other$dataFinal = other.getDataFinal();
        if (this$dataFinal == null ? other$dataFinal != null : !((Object)this$dataFinal).equals(other$dataFinal)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        return !(this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AudienciasPublicasParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $natureza = this.getNatureza();
        result = result * 59 + ($natureza == null ? 43 : $natureza.hashCode());
        String $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        LocalDate $dataInicial = this.getDataInicial();
        result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
        LocalDate $dataFinal = this.getDataFinal();
        result = result * 59 + ($dataFinal == null ? 43 : ((Object)$dataFinal).hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AudienciasPublicasParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", natureza=" + this.getNatureza() + ", tipo=" + this.getTipo() + ", dataInicial=" + this.getDataInicial() + ", dataFinal=" + this.getDataFinal() + ", id=" + this.getId() + ", exportType=" + this.getExportType() + ")";
    }
}

