/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.portaltransparencia.admportal.domain.Rota;
import br.com.elotech.portaltransparencia.admportal.domain.Template;
import br.com.elotech.portaltransparencia.admportal.repository.RotaRepository;
import br.com.elotech.portaltransparencia.admportal.service.TemplateService;
import java.time.LocalDate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RotaService
extends ReadOnlyService<Rota, Long> {
    @Autowired
    private final RotaRepository rotaRepository;
    @Autowired
    private final TemplateService templateService;

    public RotaService(RotaRepository rotaRepository, TemplateService templateService) {
        this.rotaRepository = rotaRepository;
        this.templateService = templateService;
    }

    public List<Rota> findRotasAcessiveisByTemplatePadraoDaEntidade(Long entidade) {
        Template template = this.templateService.findActiveTemplate(entidade, Long.valueOf(LocalDate.now().getYear()));
        return this.rotaRepository.findRotasAcessiveisByTemplatePadraoDaEntidade(template.getId());
    }

    public List<Rota> findRotasAcessiveisByNome(Long entidade, String nome) {
        Template template = this.templateService.findActiveTemplate(entidade, Long.valueOf(LocalDate.now().getYear()));
        return this.rotaRepository.findRotasAcessiveisByNome(template.getId(), nome);
    }
}

