/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.portaltransparencia.admportal.repository.PublicacaoRepository;
import br.com.elotech.portaltransparencia.admportal.repository.PublicacaoSubGrupoRepository;
import br.com.elotech.portaltransparencia.admportal.service.PublicacaoGrupoService;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoGrupo;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoGrupoEntidade;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoGrupoEntidadePK;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoSubGrupo;
import br.com.elotech.portaltransparencia.contabportal.repository.PublicacaoGrupoEntidadeRepository;
import java.io.Serializable;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class PublicacaoGrupoEntidadeService
extends CrudService<PublicacaoGrupoEntidade, PublicacaoGrupoEntidadePK> {
    private final PublicacaoGrupoEntidadeRepository repository;
    private final PublicacaoRepository publicacaoRepository;
    private final PublicacaoSubGrupoRepository pubSubGrupoRepository;
    private final PublicacaoGrupoService grupoService;

    protected void beforeSave(PublicacaoGrupoEntidade entity, Authentication authentication) {
        PublicacaoGrupo grupo = entity.getId().getGrupo();
        if (Objects.nonNull(grupo.getId())) {
            this.grupoService.findById((Serializable)grupo.getId()).ifPresent(publicacaoGrupo -> {
                if (!publicacaoGrupo.getDescricao().equals(grupo.getDescricao())) {
                    this.validateVinculoDescricaoExists(entity);
                }
            });
        } else {
            this.validateVinculoDescricaoExists(entity);
        }
        entity.getId().setGrupo(this.grupoService.findByDescricaoOrCreate(entity.getId().getGrupo()));
        super.beforeSave((EloEntity)entity, authentication);
    }

    private void validateVinculoDescricaoExists(PublicacaoGrupoEntidade entity) {
        PublicacaoGrupo grupo = entity.getId().getGrupo();
        this.repository.findByIdEntidadeIdAndIdGrupoDescricao(entity.getId().getEntidade().getId(), grupo.getDescricao()).ifPresent(found -> {
            throw new IllegalArgumentException(String.format("O Grupo [%s] j\u00e1 existe para a Entidade [%s].", found.getId().getGrupo().getDescricao(), entity.getId().getEntidade().getId()));
        });
    }

    protected void beforeDelete(PublicacaoGrupoEntidade entity, Authentication authentication) {
        if (this.publicacaoRepository.existsByGrupoIdIn(this.pubSubGrupoRepository.findByIdGrupoRelatorio(entity.getId().getGrupo().getId()).stream().map(PublicacaoSubGrupo::getId).collect(Collectors.toList()))) {
            throw new EloValidationException("Existem publica\u00e7\u00f5es para o Grupo em quest\u00e3o.");
        }
    }

    @Generated
    public PublicacaoGrupoEntidadeService(PublicacaoGrupoEntidadeRepository repository, PublicacaoRepository publicacaoRepository, PublicacaoSubGrupoRepository pubSubGrupoRepository, PublicacaoGrupoService grupoService) {
        this.repository = repository;
        this.publicacaoRepository = publicacaoRepository;
        this.pubSubGrupoRepository = pubSubGrupoRepository;
        this.grupoService = grupoService;
    }
}

