SELECT X.*, 
       X.CNPJ||' - '||X.NOME CNPJNOME,
	   SUBSTR(X.PROGRAMATICA,ORG.POSICAO,ORG.TAMANHO) AS ORGAO,
	   SUBSTR(X.PROGRAMATICA,UNID.POSICAO,UNID.TAMANHO) AS UNIDADE,
	   SUBSTR(X.PROGRAMATICA,FUNCAO.POSICAO,FUNCAO.TAMANHO) AS FUNCAO,
	   SUBSTR(X.PROGRAMATICA,SUBFUNCAO.POSICAO,SUBFUNCAO.TAMANHO) AS SUBFUNCAO,
	   SUBSTR(X.PROGRAMATICA,PROG.POSICAO,PROG.TAMANHO) AS PROGRAMA,
	   SUBSTR(X.PROGRAMATICA,PROJ.POSICAO,PROJ.TAMANHO) AS PROJETO,
	   SUBSTR(X.PROGRAMATICA,ELEM.POSICAO,ELEM.TAMANHO) AS ELEMENTO   
FROM (
	SELECT E.ENTIDADE,
		   E.EMPENHO,
		   E.EXERCICIO AS ANOEMPENHO,
		   E.EMPENHO||'/'||E.EXERCICIO EMPENHOEXERCICIO,
		   E.DATA AS DATAEMISSAO,
		   E.PROGRAMATICA, 
		   E.FONTERECURSO,	   
		   E.FONTERECURSO||'-'||FR.DESCRICAO AS DESCRICAOFONTE,
		   E.FORNECEDOR,
		   F.NOME,
		   CASE WHEN F.TIPOPESSOA = 'F' THEN '****' || SUBSTR(F.CNPJ, 5, 3) || '****'
				ELSE SUBSTR(F.CNPJ,1,2) || '.' || SUBSTR(F.CNPJ,3,3) || '.' || SUBSTR(F.CNPJ,6,3) || '/' || SUBSTR(F.CNPJ,9,4) || '-' || SUBSTR(F.CNPJ,13,2)
		   END AS CNPJ, 
		   SUM(CASE WHEN E.EXERCICIO = :exercicio 
					THEN B.VALORLIQUIDACOES - B.VALORESTLIQUIDACOES 
						 - B.VALORPAGAMENTO + B.VALORESTPAGAMENTO - B.VALORRETENCOES 
					WHEN (B.DATA < :dataInicial) 
					THEN B.VALORLIQUIDACOES - B.VALORESTLIQUIDACOES - B.VALORCANCELAMENTOPROC 
						 + B.VALORESTCANCELAMENTOPROC 
						 - B.VALORPAGAMENTO + B.VALORESTPAGAMENTO - B.VALORRETENCOES 
					ELSE 0 
			   END) PROC, 
		   SUM(CASE WHEN E.EXERCICIO = :exercicio
                THEN B.VALOR - B.VALORANULACOES + B.VALORESTANULACOES 
                     + B.VALORREFORCO - B.VALORESTREFORCO 
                     - B.VALORLIQUIDACOES + B.VALORESTLIQUIDACOES 
                WHEN B.DATA < :dataInicial 
                THEN B.VALOR - B.VALORANULACOES + B.VALORESTANULACOES 
                     + B.VALORREFORCO - B.VALORESTREFORCO 
                     - B.VALORLIQUIDACOES + B.VALORESTLIQUIDACOES 
                     + B.VALORCANCELAMENTOPROC - B.VALORESTCANCELAMENTOPROC 
                ELSE 0 
           END) APROC, 
		   SUM(CASE WHEN B.DATA >= :dataInicial AND B.DATA <= :dataFinal 
                THEN B.VALORCANCELAMENTOPROC - B.VALORESTCANCELAMENTOPROC 
                ELSE 0 
           END) CANCELADOPROC,
		   SUM(CASE WHEN B.DATA >= :dataInicial AND B.DATA <= :dataFinal 
                THEN B.VALORPAGOPROC - B.VALORESTPAGOPROC 
                ELSE 0 
           END) PAGOPROC, 
		   SUM(CASE WHEN B.DATA >= :dataInicial AND B.DATA <= :dataFinal 
                THEN B.VALORESTPAGOPROC 
                ELSE 0 
           END) PAGOPROCESTORNADO, 
		   SUM(CASE WHEN B.DATA >= :dataInicial AND B.DATA <= :dataFinal 
                THEN (B.VALORANULACOES - B.VALORESTANULACOES) 
                     - (B.VALORCANCELAMENTOPROC - B.VALORESTCANCELAMENTOPROC) 
                ELSE 0 
           END) CANCELADOAPROC,
		   SUM(CASE WHEN B.DATA >= :dataInicial AND B.DATA <= :dataFinal 
                THEN (B.VALORPAGAMENTO - B.VALORESTPAGAMENTO + B.VALORRETENCOES) 
                     - (B.VALORPAGOPROC - B.VALORESTPAGOPROC) 
                ELSE 0 
           END) PAGOAPROC, 
		   SUM(CASE WHEN B.DATA >= :dataInicial AND B.DATA <= :dataFinal 
                THEN B.VALORESTPAGAMENTO - B.VALORESTPAGOPROC 
                ELSE 0 
           END) PAGOAPROCESTORNADO, 
           SUM(CASE WHEN B.DATA >= :dataInicial AND B.DATA <= :dataFinal 
                THEN B.VALORRETENCOES 
                ELSE 0 
           END) RETENCAO, 
           SUM(CASE WHEN B.DATA >= :dataInicial AND B.DATA <= :dataFinal 
                THEN (B.VALORLIQUIDACOES - B.VALORESTLIQUIDACOES) 
                ELSE 0 
           END) LIQUIDADO,
		   E.DESDOBRADESP,     
		   E.SUBDESDOBRAMENTO,
		   DESP.MODELODESPESA
	  FROM ${db.contabilidade.schema}.EMPENHO E
	  LEFT OUTER JOIN ${db.contabilidade.schema}.FICHAEMPENHO B
		ON B.ENTIDADE            = E.ENTIDADE
	   AND B.EXERCICIO           = E.EXERCICIO
	   AND B.EMPENHO             = E.EMPENHO
	   AND B.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA
	  LEFT OUTER JOIN ${db.contabilidade.schema}.EXERCICIO C
		ON C.ENTIDADE  = E.ENTIDADE
	   AND C.EXERCICIO = E.EXERCICIO
	  LEFT JOIN ${db.contabilidade.schema}.FONTERECURSO FR
		ON  E.FONTERECURSO = FR.FONTERECURSO
	  LEFT JOIN ${db.contabilidade.schema}.DESPESA DESP
		ON E.ENTIDADE     = DESP.ENTIDADE
	   AND E.EXERCICIO    = DESP.EXERCICIO
	   AND E.PROGRAMATICA = DESP.PROGRAMATICA
	   AND E.FONTERECURSO = DESP.FONTERECURSO
	  LEFT OUTER JOIN ${db.contabilidade.schema}.FORNECEDOR F
		ON E.FORNECEDOR = F.FORNECEDOR	
  $[FILTRO]
 GROUP BY E.ENTIDADE,
          E.EMPENHO,
          E.EXERCICIO,
          E.DATA,
          E.PROGRAMATICA, 
          E.DESDOBRADESP,
          E.SUBDESDOBRAMENTO,
	      E.FORNECEDOR,
          E.FONTERECURSO,           
	      FR.DESCRICAO, 
          F.NOME,
	      F.TIPOPESSOA,
	      F.CNPJ,
	      DESP.MODELODESPESA
	HAVING(( CAST ( SUM(CASE WHEN B.DATA < :dataInicial                                               
                         THEN B.VALORLIQUIDACOES - B.VALORESTLIQUIDACOES - B.VALORCANCELAMENTOPROC
                              + B.VALORESTCANCELAMENTOPROC                                        
                              - B.VALORPAGAMENTO + B.VALORESTPAGAMENTO - B.VALORRETENCOES         
                         ELSE 0                                                                   
                     END) AS NUMERIC(10,2))  > 0.001 )                                            
    OR ( CAST ( SUM(CASE WHEN B.DATA < :dataInicial                                               
                         THEN B.VALOR - B.VALORANULACOES + B.VALORESTANULACOES                    
                              + B.VALORREFORCO - B.VALORESTREFORCO                                
                              - B.VALORLIQUIDACOES + B.VALORESTLIQUIDACOES                        
                              + B.VALORCANCELAMENTOPROC - B.VALORESTCANCELAMENTOPROC              
                         ELSE 0                                                                   
                     END) AS NUMERIC (10,2)) > 0.001 )                                            
    OR ( CAST ( SUM(CASE WHEN B.DATA >= :dataInicial AND B.DATA <= :dataFinal                     
                         THEN (B.VALORPAGAMENTO - B.VALORESTPAGAMENTO + B.VALORRETENCOES)         
                              - (B.VALORPAGOPROC - B.VALORESTPAGOPROC)                            
                         ELSE 0                                                                   
                    END) AS NUMERIC (10,2)) > 0.001 )                                             
    OR (E.EXERCICIO = :exercicio))                                                                
) X 
LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA ORG
  ON X.MODELODESPESA = ORG.MODELODESPESA
 AND ORG.TIPO = 'P'
 AND ORG.ORDEM = 1
LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA UNID
  ON X.MODELODESPESA = UNID.MODELODESPESA
 AND UNID.TIPO = 'C'
 AND UNID.ORDEM = 2
LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA FUNCAO
  ON X.MODELODESPESA = FUNCAO.MODELODESPESA
 AND FUNCAO.TIPO = 'P'
 AND FUNCAO.ORDEM = 3
LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA SUBFUNCAO
  ON X.MODELODESPESA = SUBFUNCAO.MODELODESPESA
 AND SUBFUNCAO.TIPO = 'P'
 AND SUBFUNCAO.ORDEM = 4
LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA PROG
  ON X.MODELODESPESA = PROG.MODELODESPESA
 AND PROG.TIPO = 'P'
 AND PROG.ORDEM = 5
LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA PROJ
  ON X.MODELODESPESA = PROJ.MODELODESPESA
 AND PROJ.TIPO = 'P'
 AND PROJ.ORDEM = 6
LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA ELEM
  ON X.MODELODESPESA = ELEM.MODELODESPESA
 AND ELEM.TIPO = 'C'
 AND ELEM.ORDEM = 7	
