/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.utils;

import br.com.elotech.portaltransparencia.contabportal.resource.params.LeisAtosParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public final class LeisAtosOxyUtils {
    private static final String GERAL = "geral";
    private static final String DESPESA = "despesa";
    private static final String RECEITA = "receita";
    private static final String PESSOAL = "pessoal";
    private static final HashMap<String, String> FILTERS_ABA = new HashMap();
    private static final HashMap<String, Function<Sort.Order, Sort.Order>> ORDERS = new HashMap();
    private static final HashMap<String, Function<String, String>> FILTERS = new HashMap();

    public static String translateSearchToOxy(LeisAtosParams params) {
        StringBuilder search = new StringBuilder();
        search.append((String)((Function)FILTERS.get("entidade")).apply(params.getEntidade().toString()));
        params.getSubAbaLeiAtos().ifPresent(subAba -> search.append(Optional.ofNullable((String)FILTERS_ABA.get(subAba)).orElse("")));
        params.getNumero().ifPresent(numero -> search.append((String)((Function)FILTERS.get("numero")).apply(numero.toString())));
        search.append((String)((Function)FILTERS.get("ano")).apply(params.getAno().map(ano -> ano.toString()).orElse(params.getExercicio().toString())));
        params.getDescricaoSumula().ifPresent(sumula -> search.append((String)((Function)FILTERS.get("descricaoSumula")).apply(sumula)));
        params.getDataInicial().ifPresent(dataInicial -> search.append((String)((Function)FILTERS.get("dataInicial")).apply(dataInicial.toString())));
        params.getDataFinal().ifPresent(dataFim -> search.append((String)((Function)FILTERS.get("dataFinal")).apply(dataFim.toString())));
        params.getTipoEscopo().ifPresent(escopo -> search.append((String)((Function)FILTERS.get("tipoEscopo")).apply(escopo.toString())));
        params.getTipoDocumentoLegal().ifPresent(tipoDocumento -> search.append((String)((Function)FILTERS.get("tipoDocumentoLegal")).apply(tipoDocumento.toString())));
        params.getNatureza().ifPresent(natureza -> search.append((String)((Function)FILTERS.get("natureza")).apply(natureza)));
        return search.substring(1);
    }

    public static Pageable translateSortToOxy(Pageable page) {
        ArrayList orders = new ArrayList();
        if (page.getSort().isSorted()) {
            page.getSort().toList().forEach(sort -> orders.add((Sort.Order)((Function)ORDERS.get(sort.getProperty())).apply(sort)));
        }
        return PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)Sort.by(orders));
    }

    static {
        FILTERS_ABA.put(GERAL, ";mostraPortal==true");
        FILTERS_ABA.put(DESPESA, ";mostraDespesa==true");
        FILTERS_ABA.put(RECEITA, ";mostraReceita==true");
        FILTERS_ABA.put(PESSOAL, ";mostraPessoal==true");
        ORDERS.put("natureza", sort -> new Sort.Order(sort.getDirection(), "tipoLeiNatureza.descricao"));
        ORDERS.put("numero", sort -> new Sort.Order(sort.getDirection(), "numero"));
        ORDERS.put("exercicio", sort -> new Sort.Order(sort.getDirection(), "ano"));
        ORDERS.put("descricao", sort -> new Sort.Order(sort.getDirection(), "tipoLeiEscopo.descricao"));
        ORDERS.put("data", sort -> new Sort.Order(sort.getDirection(), "dataCadastro"));
        ORDERS.put("sumula", sort -> new Sort.Order(sort.getDirection(), "sumula"));
        ORDERS.put("veiculoPublicacao", sort -> new Sort.Order(sort.getDirection(), "descricaoVeiculoPublicacao"));
        ORDERS.put("dataPublicacao", sort -> new Sort.Order(sort.getDirection(), "dataPublicacao"));
        ORDERS.put("tipoDocumentoLegal", sort -> new Sort.Order(sort.getDirection(), "tipoLeiDocumento.codigo"));
        FILTERS.put("entidade", filter -> ";entidade.id==" + filter);
        FILTERS.put("numero", filter -> ";numero==" + filter);
        FILTERS.put("ano", filter -> ";ano==" + filter);
        FILTERS.put("descricaoSumula", filter -> ";(tipoLeiEscopo.descricao=='*" + filter + "*',sumula=='*" + filter + "*')");
        FILTERS.put("dataInicial", filter -> ";dataAto>=" + filter);
        FILTERS.put("dataFinal", filter -> ";dataAto<=" + filter);
        FILTERS.put("tipoEscopo", filter -> ";tipoLeiEscopo.codigo==" + filter);
        FILTERS.put("tipoDocumentoLegal", filter -> ";tipoLeiDocumento.codigo==" + filter);
        FILTERS.put("natureza", filter -> ";tipoLeiNatureza.descricao=='*" + filter + "*'");
    }
}

